/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.rest;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Preconditions;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/internal/ui/status-check")
@Produces(value={"application/json"})
public class HealthCheckResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/internal/ui/status-check";
    private HealthCheckRegistry registry;

    @Inject
    public HealthCheckResource(HealthCheckRegistry registry) {
        this.registry = (HealthCheckRegistry)Preconditions.checkNotNull((Object)registry);
    }

    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    public SortedMap<String, HealthCheck.Result> getSystemStatusChecks() {
        return this.registry.runHealthChecks();
    }
}

