/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.sonatype.nexus.common.app.ReadOnlyState;

@Api(value="Read-only")
public interface FreezeResourceDoc {
    @ApiOperation(value="Get read-only state")
    public ReadOnlyState get();

    @ApiOperation(value="Prevent changes to embedded OrientDB", notes="For low-level system maintenance purposes only; do not use if you want users to still be able to download components.")
    @ApiResponses(value={@ApiResponse(code=204, message="Database is now read-only"), @ApiResponse(code=403, message="Authentication required"), @ApiResponse(code=404, message="No change to read-only state")})
    public void freeze();

    @ApiOperation(value="Release read-only and allow changes to embedded OrientDB", notes="Releases administrator-initiated read-only status. Will not release read-only status caused by system tasks.")
    @ApiResponses(value={@ApiResponse(code=204, message="Database is no longer read-only"), @ApiResponse(code=403, message="Authentication required"), @ApiResponse(code=404, message="No change to read-only state")})
    public void release();

    @ApiOperation(value="Forcibly release read-only and allow changes to embedded OrientDB", notes="Forcibly release read-only status, including if caused by system tasks. Warning: may result in data loss.")
    @ApiResponses(value={@ApiResponse(code=204, message="Database is no longer read-only"), @ApiResponse(code=403, message="Authentication required"), @ApiResponse(code=404, message="No change to read-only state")})
    public void forceRelease();
}

