/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.transaction.RetryController;

@Named
@Singleton
@ManagedObject
public class RetryControllerBean {
    private final RetryController retryController;

    @Inject
    public RetryControllerBean(RetryController retryController) {
        this.retryController = (RetryController)Preconditions.checkNotNull((Object)retryController);
    }

    @ManagedAttribute
    public int getRetryLimit() {
        return this.retryController.getRetryLimit();
    }

    @ManagedAttribute
    public void setRetryLimit(int retryLimit) {
        this.retryController.setRetryLimit(retryLimit);
    }

    @ManagedAttribute
    public int getMinSlots() {
        return this.retryController.getMinSlots();
    }

    @ManagedAttribute
    public void setMinSlots(int minSlots) {
        this.retryController.setMinSlots(minSlots);
    }

    @ManagedAttribute
    public int getMaxSlots() {
        return this.retryController.getMaxSlots();
    }

    @ManagedAttribute
    public void setMaxSlots(int maxSlots) {
        this.retryController.setMaxSlots(maxSlots);
    }

    @ManagedAttribute
    public int getMinorDelayMillis() {
        return this.retryController.getMinorDelayMillis();
    }

    @ManagedAttribute
    public void setMinorDelayMillis(int minorDelayMillis) {
        this.retryController.setMinorDelayMillis(minorDelayMillis);
    }

    @ManagedAttribute
    public int getMajorDelayMillis() {
        return this.retryController.getMajorDelayMillis();
    }

    @ManagedAttribute
    public void setMajorDelayMillis(int majorDelayMillis) {
        this.retryController.setMajorDelayMillis(majorDelayMillis);
    }

    @ManagedAttribute
    public String getMajorExceptionFilter() {
        return this.retryController.majorExceptionFilter().getFilterString();
    }

    @ManagedAttribute
    public void setMajorExceptionFilter(String majorExceptionFilter) {
        this.retryController.majorExceptionFilter().setFilterString(majorExceptionFilter);
    }

    @ManagedAttribute
    public String getNoisyExceptionFilter() {
        return this.retryController.noisyExceptionFilter().getFilterString();
    }

    @ManagedAttribute
    public void setNoisyExceptionFilter(String noisyExceptionFilter) {
        this.retryController.noisyExceptionFilter().setFilterString(noisyExceptionFilter);
    }
}

