/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.io.DirectoryHelper;
import org.sonatype.nexus.jmx.reflect.ManagedAttribute;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.orient.DatabaseExternalizerImpl;
import org.sonatype.nexus.orient.DatabaseManagerSupport;
import org.sonatype.nexus.orient.DatabaseRestorer;

@Named
@Singleton
@ManagedObject
public class DatabaseManagerImpl
extends DatabaseManagerSupport {
    public static final String WORK_PATH = "db";
    private final File databasesDirectory;
    private final DatabaseRestorer databaseRestorer;

    @Inject
    public DatabaseManagerImpl(ApplicationDirectories applicationDirectories, DatabaseRestorer databaseRestorer) {
        Preconditions.checkNotNull((Object)applicationDirectories);
        this.databasesDirectory = applicationDirectories.getWorkDirectory(WORK_PATH);
        this.log.debug("Databases directory: {}", (Object)this.databasesDirectory);
        this.databaseRestorer = (DatabaseRestorer)Preconditions.checkNotNull((Object)databaseRestorer);
    }

    @VisibleForTesting
    public DatabaseManagerImpl(File databasesDirectory, DatabaseRestorer databaseRestorer) {
        this.databasesDirectory = (File)Preconditions.checkNotNull((Object)databasesDirectory);
        this.log.debug("Databases directory: {}", (Object)databasesDirectory);
        this.databaseRestorer = (DatabaseRestorer)Preconditions.checkNotNull((Object)databaseRestorer);
    }

    @ManagedAttribute
    public File getDatabasesDirectory() {
        return this.databasesDirectory;
    }

    private File directory(String name) throws IOException {
        return new File(this.databasesDirectory, name).getCanonicalFile();
    }

    protected String connectionUri(String name) {
        try {
            File dir = this.directory(name);
            DirectoryHelper.mkdir((File)dir);
            return "plocal:" + OFileUtils.getPath((String)dir.getAbsolutePath()).replace("//", "/");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void created(ODatabaseDocumentTx db, String name) throws Exception {
        File dir = this.directory(name);
        if (!this.databaseRestorer.maybeRestoreDatabase(db, name)) {
            DatabaseExternalizerImpl externalizer = this.externalizer(name);
            externalizer.maybeImportFromStandardLocation(db, dir);
        }
    }
}

