/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node.datastore;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.node.datastore.SystemInformationResourceDoc;
import org.sonatype.nexus.node.datastore.NodeHeartbeatManager;
import org.sonatype.nexus.rest.Resource;

@Produces(value={"application/json"})
@Path(value="/beta/system/information")
@Named
@Singleton
public class SystemInformationResource
extends ComponentSupport
implements Resource,
SystemInformationResourceDoc {
    public static final String PATH = "/beta/system/information";
    private final NodeHeartbeatManager nodeHeartbeatManager;

    @Inject
    public SystemInformationResource(NodeHeartbeatManager nodeHeartbeatManager) {
        this.nodeHeartbeatManager = (NodeHeartbeatManager)Preconditions.checkNotNull((Object)nodeHeartbeatManager);
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public Map<String, Map<String, Object>> getSystemInformation() {
        return this.nodeHeartbeatManager.getSystemInformationForNodes();
    }
}

