/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node.datastore;

import com.google.common.base.Preconditions;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.node.NodeIdEncoding;
import org.sonatype.nexus.internal.node.NodeIdInitializer;
import org.sonatype.nexus.node.datastore.NodeIdStore;
import org.sonatype.nexus.ssl.KeyStoreManager;
import org.sonatype.nexus.ssl.KeystoreException;

@Named
@Singleton
public class NodeIdInitializerImpl
extends ComponentSupport
implements NodeIdInitializer {
    private final NodeIdStore nodeIdStore;
    private final Provider<KeyStoreManager> keyStoreProvider;

    @Inject
    public NodeIdInitializerImpl(@Named(value="node") @Named(value="node") Provider<KeyStoreManager> keyStoreProvider, NodeIdStore nodeIdStore) {
        this.nodeIdStore = (NodeIdStore)Preconditions.checkNotNull((Object)nodeIdStore);
        this.keyStoreProvider = (Provider)Preconditions.checkNotNull(keyStoreProvider);
    }

    @Override
    public void initialize() {
        if (!this.nodeIdStore.get().isPresent()) {
            this.migrateNodeId();
        }
    }

    private void migrateNodeId() {
        this.log.info("No node-id found. Attempting to migrate from KeyStore");
        KeyStoreManager keyStoreManager = (KeyStoreManager)this.keyStoreProvider.get();
        if (!keyStoreManager.isKeyPairInitialized()) {
            this.generateNodeId();
            return;
        }
        this.log.info("Migrating node-id to database");
        try {
            Certificate certificate = keyStoreManager.getCertificate();
            this.log.trace("Certificate:\n{}", (Object)certificate);
            String id = NodeIdEncoding.nodeIdForCertificate(certificate);
            this.nodeIdStore.set(id);
        }
        catch (CertificateEncodingException | KeystoreException throwable) {
            this.generateNodeId();
        }
    }

    private void generateNodeId() {
        this.log.info("Unable to get node-id from KeyStore - Generating a new node-id");
        this.nodeIdStore.getOrCreate();
    }
}

