/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.internal.node.DeploymentIdStore;

@Named
@Singleton
public class SimpleDeploymentAccess
implements DeploymentAccess {
    private final DeploymentIdStore deploymentIdStore;

    @Inject
    public SimpleDeploymentAccess(DeploymentIdStore deploymentIdStore) {
        this.deploymentIdStore = (DeploymentIdStore)Preconditions.checkNotNull((Object)deploymentIdStore);
    }

    public String getId() {
        return this.deploymentIdStore.get().orElseThrow(() -> new RuntimeException("Deployment id is absent."));
    }

    public String getAlias() {
        return null;
    }

    public void setAlias(String newAlias) {
        throw new UnsupportedOperationException();
    }

    public void start() {
    }

    public void stop() {
    }
}

