/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.node.DeploymentIdStore;
import org.sonatype.nexus.node.datastore.NodeIdStore;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationStep;

@Named
public class DeploymentIdUpgradeStep_1_23
extends ComponentSupport
implements DatabaseMigrationStep {
    private final NodeIdStore nodeIdStore;
    private final DeploymentIdStore deploymentIdStore;

    @Inject
    public DeploymentIdUpgradeStep_1_23(DeploymentIdStore deploymentIdStore, NodeIdStore nodeIdStore) {
        this.nodeIdStore = (NodeIdStore)Preconditions.checkNotNull((Object)nodeIdStore);
        this.deploymentIdStore = (DeploymentIdStore)Preconditions.checkNotNull((Object)deploymentIdStore);
    }

    public Optional<String> version() {
        return Optional.of("1.23");
    }

    public void migrate(Connection connection) {
        Optional<String> deploymentId = this.deploymentIdStore.get();
        if (deploymentId.isPresent()) {
            return;
        }
        Optional<String> nodeId = this.nodeIdStore.get();
        this.deploymentIdStore.set(nodeId.orElseThrow(() -> new RuntimeException("Could not migrate deployment id. Reason: deploymentId and nodeId are absent.")));
        deploymentId = this.deploymentIdStore.get();
        if (deploymentId.isPresent()) {
            this.log.debug("Migration of deployment id was successful.");
        }
    }
}

