/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.node;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.internal.node.DeploymentIdDAO;
import org.sonatype.nexus.internal.node.DeploymentIdStore;
import org.sonatype.nexus.transaction.Transactional;

@Named
@Singleton
public class DeploymentIdStoreImpl
extends ConfigStoreSupport<DeploymentIdDAO>
implements DeploymentIdStore {
    private boolean initialized;
    private Optional<String> deploymentId;

    @Inject
    public DeploymentIdStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    @Transactional
    public Optional<String> get() {
        if (!this.initialized) {
            this.deploymentId = ((DeploymentIdDAO)this.dao()).get();
            if (this.deploymentId.isPresent()) {
                this.initialized = true;
            }
        }
        return this.deploymentId;
    }

    @Override
    @Transactional
    public void set(String deploymentId) {
        Preconditions.checkNotNull((Object)deploymentId);
        ((DeploymentIdDAO)this.dao()).set(deploymentId);
        this.deploymentId = Optional.of(deploymentId);
        this.initialized = true;
    }
}

