/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.metrics;

import com.codahale.metrics.servlet.InstrumentedFilter;
import com.codahale.metrics.servlets.PingServlet;
import com.google.inject.servlet.ServletModule;
import javax.servlet.Filter;
import javax.servlet.http.HttpServlet;
import org.sonatype.nexus.internal.metrics.HealthCheckServlet;
import org.sonatype.nexus.internal.metrics.MetricsServlet;
import org.sonatype.nexus.internal.metrics.ThreadDumpServlet;
import org.sonatype.nexus.security.SecurityFilter;

public abstract class MetricsServletModule
extends ServletModule {
    private final String mountPoint;

    protected MetricsServletModule(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    protected void configureServlets() {
        this.bind(MetricsServlet.class);
        this.bind(HealthCheckServlet.class);
        this.serve(String.valueOf(this.mountPoint) + "/ping", new String[0]).with((HttpServlet)new PingServlet());
        this.serve(String.valueOf(this.mountPoint) + "/threads", new String[0]).with((HttpServlet)new ThreadDumpServlet());
        this.serve(String.valueOf(this.mountPoint) + "/data", new String[0]).with(MetricsServlet.class);
        this.serve(String.valueOf(this.mountPoint) + "/healthcheck", new String[0]).with(HealthCheckServlet.class);
        this.serve(String.valueOf(this.mountPoint) + "/prometheus", new String[0]).with((HttpServlet)new io.prometheus.client.exporter.MetricsServlet());
        this.filter("/*", new String[0]).through((Filter)new InstrumentedFilter());
        this.bind(SecurityFilter.class);
        this.bindSecurityFilter();
    }

    protected abstract void bindSecurityFilter();
}

