/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log.overrides.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.internal.log.LoggerOverrides;
import org.sonatype.nexus.internal.log.overrides.LogbackLoggerOverridesSupport;

@Named
@Singleton
public class LogbackLoggerOverrides
extends LogbackLoggerOverridesSupport
implements LoggerOverrides {
    private final Map<String, LoggerLevel> loggerLevels = new HashMap<String, LoggerLevel>();

    @Inject
    public LogbackLoggerOverrides(ApplicationDirectories applicationDirectories) {
        super(applicationDirectories);
    }

    @VisibleForTesting
    LogbackLoggerOverrides(File file) {
        super(file);
    }

    @Override
    public synchronized void load() {
        this.log.debug("Load");
        this.loggerLevels.clear();
        if (this.logbackFileExists()) {
            try {
                this.loggerLevels.putAll(this.readFromFile());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized void save() {
        this.log.debug("Save");
        try {
            this.writeToFile(this.loggerLevels);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, LoggerLevel> syncWithDBAndGet() {
        return this.loggerLevels;
    }

    @Override
    public synchronized void reset() {
        this.log.debug("Reset");
        this.loggerLevels.clear();
        try {
            this.writeToFile(this.loggerLevels);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void set(String name, LoggerLevel level) {
        this.log.debug("Set: {}={}", (Object)name, (Object)level);
        this.loggerLevels.put(name, level);
    }

    @Override
    @Nullable
    public synchronized LoggerLevel get(String name) {
        return this.loggerLevels.get(name);
    }

    @Override
    @Nullable
    public synchronized LoggerLevel remove(String name) {
        this.log.debug("Remove: {}", (Object)name);
        return this.loggerLevels.remove(name);
    }

    @Override
    public synchronized boolean contains(String name) {
        return this.loggerLevels.containsKey(name);
    }

    @Override
    public synchronized Iterator<Map.Entry<String, LoggerLevel>> iterator() {
        return ImmutableMap.copyOf(this.loggerLevels).entrySet().iterator();
    }
}

