/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log.overrides.datastore;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.internal.log.overrides.datastore.LoggerOverridesEvent;
import org.sonatype.nexus.internal.log.overrides.datastore.LoggingOverridesDAO;
import org.sonatype.nexus.internal.log.overrides.datastore.LoggingOverridesData;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class LoggingOverridesStore
extends ConfigStoreSupport<LoggingOverridesDAO> {
    @Inject
    protected LoggingOverridesStore(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Transactional
    public void create(LoggingOverridesData data) {
        ((LoggingOverridesDAO)this.dao()).createRecord(data);
        this.postCommitEvent(() -> new LoggerOverridesEvent(data.getName(), data.getLevel(), LoggerOverridesEvent.Action.CHANGE));
    }

    @Transactional
    public Continuation<LoggingOverridesData> readRecords() {
        return ((LoggingOverridesDAO)this.dao()).readRecords(null);
    }

    @Transactional
    public boolean exists(String name) {
        return this.readRecords().stream().anyMatch(level -> level.getName().equals(name));
    }

    @Transactional
    public void update(LoggingOverridesData data) {
        ((LoggingOverridesDAO)this.dao()).updateRecord(data);
        this.postCommitEvent(() -> new LoggerOverridesEvent(data.getName(), data.getLevel(), LoggerOverridesEvent.Action.CHANGE));
    }

    @Transactional
    public void deleteByName(String name) {
        ((LoggingOverridesDAO)this.dao()).deleteRecord(name);
        this.postCommitEvent(() -> new LoggerOverridesEvent(name, null, LoggerOverridesEvent.Action.RESET));
    }

    @Transactional
    public void deleteAllRecords() {
        ((LoggingOverridesDAO)this.dao()).deleteAllRecords();
        this.postCommitEvent(() -> new LoggerOverridesEvent(null, null, LoggerOverridesEvent.Action.RESET_ALL));
    }
}

