/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log.overrides.datastore;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.common.log.LoggerOverridesReloadEvent;
import org.sonatype.nexus.internal.log.LoggerOverrides;
import org.sonatype.nexus.internal.log.overrides.LogbackLoggerOverridesSupport;
import org.sonatype.nexus.internal.log.overrides.datastore.LoggingOverridesData;
import org.sonatype.nexus.internal.log.overrides.datastore.LoggingOverridesStore;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
public class DatastoreLoggerOverrides
extends LogbackLoggerOverridesSupport
implements LoggerOverrides {
    private final LoggingOverridesStore loggingLevelsStore;
    private final EventManager eventManager;
    private final Map<String, LoggerLevel> loggerLevels = new ConcurrentHashMap<String, LoggerLevel>();
    private final ReentrantReadWriteLock loggerLevelsLock = new ReentrantReadWriteLock();

    @Inject
    public DatastoreLoggerOverrides(ApplicationDirectories appDirectories, LoggingOverridesStore loggingLevelsStore, EventManager eventManager) {
        super(appDirectories);
        this.loggingLevelsStore = (LoggingOverridesStore)((Object)Preconditions.checkNotNull((Object)((Object)loggingLevelsStore)));
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public void load() {
        this.loggerLevels.clear();
        if (this.logbackFileExists()) {
            try {
                this.loggerLevels.putAll(this.readFromFile());
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected void doStart() throws Exception {
        this.log.debug("Load overrides from datastore");
        this.syncWithDBAndGet();
        List<LoggingOverridesData> levelsMigrateToDb = this.loggerLevels.entrySet().stream().filter(entry -> !this.loggingLevelsStore.exists((String)entry.getKey())).map(entry -> new LoggingOverridesData((String)entry.getKey(), ((LoggerLevel)entry.getValue()).toString())).collect(Collectors.toList());
        this.eventManager.post((Object)new LoggerOverridesReloadEvent());
        levelsMigrateToDb.forEach(this.loggingLevelsStore::create);
    }

    @Override
    public Map<String, LoggerLevel> syncWithDBAndGet() {
        this.loggerLevelsLock.writeLock().lock();
        Continuation<LoggingOverridesData> levels = this.loggingLevelsStore.readRecords();
        levels.forEach(data -> {
            LoggerLevel loggerLevel = this.loggerLevels.put(data.getName(), LoggerLevel.valueOf((String)data.getLevel()));
        });
        this.loggerLevelsLock.writeLock().unlock();
        return this.loggerLevels;
    }

    @Override
    public void reset() {
        this.loggerLevels.clear();
        this.loggingLevelsStore.deleteAllRecords();
    }

    @Override
    public void set(String name, LoggerLevel level) {
        this.loggerLevels.put(name, level);
        LoggingOverridesData data = new LoggingOverridesData(name, level.toString());
        if (this.loggingLevelsStore.exists(name)) {
            this.loggingLevelsStore.update(data);
        } else {
            this.loggingLevelsStore.create(data);
        }
    }

    @Override
    @Nullable
    public LoggerLevel get(String name) {
        return this.loggerLevels.get(name);
    }

    @Override
    @Nullable
    public LoggerLevel remove(String name) {
        LoggerLevel removed = this.loggerLevels.remove(name);
        this.loggingLevelsStore.deleteByName(name);
        return removed;
    }

    @Override
    public boolean contains(String name) {
        return this.loggerLevels.containsKey(name);
    }

    @Override
    public Iterator<Map.Entry<String, LoggerLevel>> iterator() {
        return ImmutableMap.copyOf(this.loggerLevels).entrySet().iterator();
    }

    @Override
    public void save() {
    }
}

