/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log.overrides;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sonatype.goodies.common.FileReplacer;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.io.SafeXml;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class LogbackLoggerOverridesSupport
extends StateGuardLifecycleSupport {
    private static final String LOGBACK_OVERRIDES_FILENAME = "logback-overrides.xml";
    private final File logbackFile;

    protected LogbackLoggerOverridesSupport(ApplicationDirectories applicationDirectories) {
        this(new File(((ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories)).getWorkDirectory("etc/logback"), LOGBACK_OVERRIDES_FILENAME));
    }

    protected LogbackLoggerOverridesSupport(File logbackFile) {
        this.logbackFile = (File)Preconditions.checkNotNull((Object)logbackFile);
        this.log.info("File: {}", (Object)logbackFile);
    }

    protected boolean logbackFileExists() {
        return this.logbackFile.exists();
    }

    protected Map<String, LoggerLevel> readFromFile() throws Exception {
        final HashMap result = Maps.newHashMap();
        SAXParserFactory parserFactory = SafeXml.newSaxParserFactory();
        parserFactory.setValidating(false);
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        parser.parse(this.logbackFile, new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("logger".equals(localName)) {
                    String name = attributes.getValue("name");
                    String level = attributes.getValue("level");
                    result.put(name, LoggerLevel.valueOf((String)level));
                }
            }
        });
        return result;
    }

    protected void writeToFile(Map<String, LoggerLevel> overrides) throws Exception {
        FileReplacer fileReplacer = new FileReplacer(this.logbackFile);
        fileReplacer.setDeleteBackupFile(true);
        fileReplacer.replace(output -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));){
                out.write("<?xml version='1.0' encoding='UTF-8'?>");
                out.newLine();
                out.newLine();
                out.write("<!--");
                out.newLine();
                out.write("DO NOT EDIT - Automatically generated; User-customized logging levels");
                out.newLine();
                out.write("-->");
                out.newLine();
                out.newLine();
                out.write("<included>");
                out.newLine();
                for (Map.Entry entry : overrides.entrySet()) {
                    if ("ROOT".equals(entry.getKey())) {
                        out.write(String.format("  <property name='root.level' value='%s'/>%n", entry.getValue()));
                        continue;
                    }
                    out.write(String.format("  <logger name='%s' level='%s'/>%n", entry.getKey(), entry.getValue()));
                }
                out.write("</included>");
                out.newLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }
}

