/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;

@Named
@Singleton
public class LoggingSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    private static final String DOMAIN_VALUE = "logging";
    private static final String MARK_DESCRIPTION_BASE = "Mark permission for ";
    public static final String LOGGING_ALL_PRIV_ID = "nx-logging-all";
    public static final String LOGGING_READ_PRIV_ID = "nx-logging-read";
    public static final String LOGGING_UPDATE_PRIV_ID = "nx-logging-update";
    public static final String LOGGING_MARK_PRIV_ID = "nx-logging-mark";

    public MemorySecurityConfiguration getContribution() {
        MemorySecurityConfiguration configuration = new MemorySecurityConfiguration();
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(LOGGING_ALL_PRIV_ID, "All permissions for " + StringUtils.capitalize((String)DOMAIN_VALUE), DOMAIN_VALUE, "*"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(LOGGING_READ_PRIV_ID, "Read permission for " + StringUtils.capitalize((String)DOMAIN_VALUE), DOMAIN_VALUE, "read"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(LOGGING_UPDATE_PRIV_ID, "Update permission for " + StringUtils.capitalize((String)DOMAIN_VALUE), DOMAIN_VALUE, "update,read"));
        configuration.addPrivilege((CPrivilege)this.createApplicationPrivilege(LOGGING_MARK_PRIV_ID, MARK_DESCRIPTION_BASE + StringUtils.capitalize((String)DOMAIN_VALUE), DOMAIN_VALUE, "create"));
        return configuration;
    }
}

