/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.ByteStreams;
import com.google.inject.Key;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.LogConfigurationCustomizer;
import org.sonatype.nexus.common.log.LogManager;
import org.sonatype.nexus.common.log.LoggerLevel;
import org.sonatype.nexus.common.log.LoggerLevelChangedEvent;
import org.sonatype.nexus.common.log.LoggerOverridesReloadEvent;
import org.sonatype.nexus.common.log.LoggersResetEvent;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.log.LogbackLevels;
import org.sonatype.nexus.internal.log.LoggerOverrides;
import org.sonatype.nexus.internal.log.overrides.datastore.LoggerOverridesEvent;
import org.sonatype.nexus.logging.task.TaskLogHome;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.KERNEL)
@Singleton
public class LogbackLogManager
extends StateGuardLifecycleSupport
implements LogManager {
    private final EventManager eventManager;
    private final BeanLocator beanLocator;
    private final Map<String, LoggerLevel> customizations;
    private final LoggerOverrides overrides;
    private final List<String> allowedFilePrefixes = Arrays.asList("tasks/", "replication/");

    @Inject
    public LogbackLogManager(EventManager eventManager, BeanLocator beanLocator, LoggerOverrides overrides) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.overrides = (LoggerOverrides)Preconditions.checkNotNull((Object)overrides);
        this.customizations = new HashMap<String, LoggerLevel>();
    }

    protected void doStart() throws Exception {
        this.configure();
        this.beanLocator.watch(Key.get(LogConfigurationCustomizer.class, Named.class), (Mediator)new CustomizerMediator(), (Object)this);
        this.eventManager.register((Object)this);
    }

    private void configure() {
        this.log.info("Configuring");
        this.customizations.clear();
        this.overrides.load();
        this.applyOverrides();
    }

    protected void doStop() throws Exception {
        LogbackLogManager.loggerContext().stop();
        this.eventManager.unregister((Object)this);
    }

    @Guarded(by={"STARTED"})
    public Optional<String> getLogFor(String loggerName) {
        return LogbackLogManager.getLogFor(loggerName, LogbackLogManager.appenders());
    }

    @Guarded(by={"STARTED"})
    public Optional<File> getLogFileForLogger(String loggerName) {
        return this.getLogFor(loggerName).map(this::getLogFile);
    }

    @VisibleForTesting
    static Optional<String> getLogFor(String loggerName, Collection<Appender<ILoggingEvent>> appenders) {
        return appenders.stream().filter(appender -> loggerName.equals(appender.getName())).filter(FileAppender.class::isInstance).map(fileAppender -> ((FileAppender)fileAppender).getFile()).map(FilenameUtils::getName).filter(Objects::nonNull).findFirst();
    }

    @Guarded(by={"STARTED"})
    public Set<File> getLogFiles() {
        return LogbackLogManager.appenders().stream().filter(FileAppender.class::isInstance).map(fileAppender -> ((FileAppender)fileAppender).getFile()).map(File::new).filter(file -> file.length() > 0L).collect(Collectors.toSet());
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public File getLogFile(String fileName) {
        String filePrefix = this.allowedFilePrefixes.stream().filter(fileName::startsWith).findAny().orElse("");
        return Objects.requireNonNull(this.getAllLogFiles(fileName)).stream().filter(file -> fileName.equals(String.valueOf(filePrefix) + file.getName())).findFirst().orElseGet(() -> {
            this.logFileNotFound(fileName);
            return null;
        });
    }

    @VisibleForTesting
    void logFileNotFound(String fileName) {
        this.log.info("Unable to find log file: {}", (Object)fileName);
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public InputStream getLogFileStream(String fileName, long from, long count) throws IOException {
        this.log.debug("Retrieving log file");
        boolean containsPathSeparator = fileName.contains(File.pathSeparator) || fileName.contains("/");
        boolean startsWithAllowedPrefix = this.allowedFilePrefixes.stream().anyMatch(fileName::startsWith);
        if (!startsWithAllowedPrefix && containsPathSeparator) {
            this.log.warn("Cannot retrieve log files with path separators in their name, unless it is a task or replication log");
            return null;
        }
        File file = this.getLogFile(fileName);
        if (file == null || !file.exists()) {
            this.log.info("Log file does not exist: {}", (Object)fileName);
            this.log.debug("Failed to find logfile: {}", (Object)fileName);
            return null;
        }
        long fromByte = from;
        long bytesCount = count;
        if (count < 0L) {
            bytesCount = Math.abs(count);
            fromByte = Math.max(0L, file.length() - bytesCount);
        }
        BufferedInputStream input = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        if (fromByte == 0L && bytesCount >= file.length()) {
            return input;
        }
        long skippedBytes = 0L;
        while (skippedBytes < fromByte) {
            skippedBytes += ((InputStream)input).skip(fromByte - skippedBytes);
        }
        return ByteStreams.limit((InputStream)input, (long)bytesCount);
    }

    @Guarded(by={"STARTED"})
    public Map<String, LoggerLevel> getLoggers() {
        Level level;
        String name;
        HashMap<String, LoggerLevel> loggers = new HashMap<String, LoggerLevel>();
        LoggerContext ctx = LogbackLogManager.loggerContext();
        for (Logger logger : ctx.getLoggerList()) {
            name = logger.getName();
            level = logger.getLevel();
            if (level == null) continue;
            loggers.put(name, LogbackLevels.convert(level));
        }
        for (Map.Entry entry : this.customizations.entrySet()) {
            name = (String)entry.getKey();
            level = (LoggerLevel)entry.getValue();
            if (loggers.containsKey(name)) continue;
            if (LoggerLevel.DEFAULT == level) {
                level = this.getLoggerEffectiveLevel((String)entry.getKey());
            }
            loggers.put(name, (LoggerLevel)level);
        }
        return loggers;
    }

    @Guarded(by={"STARTED"})
    public Map<String, LoggerLevel> getOverriddenLoggers() {
        HashMap<String, LoggerLevel> loggers = new HashMap<String, LoggerLevel>();
        this.overrides.forEach(override -> {
            LoggerLevel loggerLevel = loggers.put((String)override.getKey(), (LoggerLevel)override.getValue());
        });
        return loggers;
    }

    @Guarded(by={"STARTED"})
    public void resetLoggers() {
        this.log.debug("Resetting loggers");
        this.resetAllLoggers();
        this.overrides.reset();
        this.setLoggerLevel("ROOT", LoggerLevel.DEFAULT);
        this.applyCustomizations();
        this.eventManager.post((Object)new LoggersResetEvent());
        this.log.debug("Loggers reset to default levels");
    }

    @Guarded(by={"STARTED"})
    public void setLoggerLevel(String name, @Nullable LoggerLevel level) {
        if (level == null) {
            this.unsetLoggerLevel(name);
            return;
        }
        this.log.debug("Set logger level: {}={}", (Object)name, (Object)level);
        LoggerLevel calculated = null;
        if ("ROOT".equals(name)) {
            calculated = level == LoggerLevel.DEFAULT ? LoggerLevel.INFO : level;
            this.overrides.set(name, calculated);
        } else if (level == LoggerLevel.DEFAULT) {
            boolean customizedByUser = this.overrides.contains(name) && !this.customizations.containsKey(name);
            this.unsetLoggerLevel(name);
            if (customizedByUser) {
                calculated = this.getLoggerEffectiveLevel(name);
                this.overrides.set(name, calculated);
            } else {
                LoggerLevel customizedLevel = this.customizations.get(name);
                if (customizedLevel != null && customizedLevel != LoggerLevel.DEFAULT) {
                    calculated = customizedLevel;
                }
            }
        } else {
            calculated = level;
            this.overrides.set(name, calculated);
        }
        this.overrides.save();
        if (calculated != null) {
            this.setLogbackLoggerLevel(name, LogbackLevels.convert(calculated));
        }
        this.eventManager.post((Object)new LoggerLevelChangedEvent(name, level));
    }

    @Guarded(by={"STARTED"})
    public void unsetLoggerLevel(String name) {
        this.log.debug("Unset logger level: {}", (Object)name);
        if (this.overrides.remove(name) != null) {
            this.overrides.save();
        }
        this.unsetLogger(name);
        this.eventManager.post((Object)new LoggerLevelChangedEvent(name, null));
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public LoggerLevel getLoggerLevel(String name) {
        Level level = LogbackLogManager.loggerContext().getLogger(name).getLevel();
        if (level != null) {
            return LogbackLevels.convert(level);
        }
        return null;
    }

    @Guarded(by={"STARTED"})
    public LoggerLevel getLoggerEffectiveLevel(String name) {
        Level level = LogbackLogManager.loggerContext().getLogger(name).getEffectiveLevel();
        return LogbackLevels.convert(level);
    }

    private void setLogbackLoggerLevel(String name, @Nullable Level level) {
        this.log.trace("Set logback logger level: {}={}", (Object)name, (Object)level);
        LogbackLogManager.loggerContext().getLogger(name).setLevel(level);
    }

    private void unsetLogger(String name) {
        if ("ROOT".equals(name)) {
            this.setLogbackLoggerLevel(name, Level.INFO);
        } else {
            this.setLogbackLoggerLevel(name, null);
        }
    }

    private void resetAllLoggers() {
        for (Map.Entry entry : this.overrides) {
            if ("ROOT".equals(entry.getKey())) continue;
            this.setLogbackLoggerLevel((String)entry.getKey(), null);
        }
    }

    @Subscribe
    public void on(LoggerOverridesReloadEvent event) {
        this.log.debug("Received event {}. Reload logger overrides", (Object)event);
        this.applyOverrides();
    }

    @Subscribe
    public void on(LoggerOverridesEvent loggerOverridesEvent) {
        if (loggerOverridesEvent.isLocal()) {
            return;
        }
        this.log.debug("Received event {}. Propagating logger overrides changes", (Object)loggerOverridesEvent);
        String name = loggerOverridesEvent.getName();
        String strLevel = loggerOverridesEvent.getLevel();
        Level level = Objects.isNull(strLevel) ? null : Level.toLevel((String)strLevel);
        Map<String, LoggerLevel> loggerLevels = this.overrides.syncWithDBAndGet();
        if (loggerOverridesEvent.getAction() == LoggerOverridesEvent.Action.CHANGE) {
            this.log.trace("Setting log level to {} for logger named '{}' in the scope of log overrides propagation", (Object)name, (Object)level);
            LoggerLevel loggerLevel = LoggerLevel.valueOf((String)strLevel);
            loggerLevels.put(name, loggerLevel);
            this.setLogbackLoggerLevel(name, level);
            this.eventManager.post((Object)new LoggerLevelChangedEvent(name, loggerLevel));
        } else if (loggerOverridesEvent.getAction() == LoggerOverridesEvent.Action.RESET) {
            this.log.trace("Reset log level for logger named '{}' in the scope of log overrides propagation", (Object)name);
            loggerLevels.remove(name);
            this.unsetLogger(name);
            this.eventManager.post((Object)new LoggerLevelChangedEvent(name, null));
        } else if (loggerOverridesEvent.getAction() == LoggerOverridesEvent.Action.RESET_ALL) {
            this.log.trace("Resetting all logger levels in the scope of log overrides propagation");
            this.resetAllLoggers();
            loggerLevels.clear();
            this.setLoggerLevel("ROOT", LoggerLevel.DEFAULT);
            loggerLevels.put("ROOT", LoggerLevel.INFO);
            this.setLogbackLoggerLevel("ROOT", LogbackLevels.convert(LoggerLevel.INFO));
            this.eventManager.post((Object)new LoggerLevelChangedEvent("ROOT", LoggerLevel.DEFAULT));
            this.applyCustomizations();
            this.eventManager.post((Object)new LoggersResetEvent());
        }
    }

    private void applyOverrides() {
        this.overrides.forEach(entry -> this.setLogbackLoggerLevel((String)entry.getKey(), LogbackLevels.convert((LoggerLevel)entry.getValue())));
    }

    @VisibleForTesting
    void registerCustomization(LogConfigurationCustomizer customizer) {
        this.log.debug("Registering customizations: {}", (Object)customizer);
        customizer.customize((name, level) -> {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)level);
            this.customizations.put(name, level);
            if (!this.overrides.contains(name) && level != LoggerLevel.DEFAULT) {
                this.setLogbackLoggerLevel(name, LogbackLevels.convert(level));
            }
        });
    }

    private void applyCustomizations() {
        this.log.debug("Applying customizations");
        for (Map.Entry<String, LoggerLevel> entry : this.customizations.entrySet()) {
            if (entry.getValue() == LoggerLevel.DEFAULT) continue;
            this.setLogbackLoggerLevel(entry.getKey(), LogbackLevels.convert(entry.getValue()));
        }
    }

    @VisibleForTesting
    static LoggerContext loggerContext() {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (factory instanceof LoggerContext) {
            return (LoggerContext)factory;
        }
        return (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
    }

    private static Collection<Appender<ILoggingEvent>> appenders() {
        ArrayList<Appender<ILoggingEvent>> result = new ArrayList<Appender<ILoggingEvent>>();
        for (Logger log : LogbackLogManager.loggerContext().getLoggerList()) {
            Iterator iter = log.iteratorForAppenders();
            while (iter.hasNext()) {
                result.add((Appender<ILoggingEvent>)((Appender)iter.next()));
            }
        }
        return result;
    }

    @VisibleForTesting
    Set<File> getAllLogFiles(String fileName) {
        if (fileName.startsWith("tasks/") && fileName.endsWith(".log")) {
            try {
                Throwable throwable = null;
                Object var3_8 = null;
                try (Stream<Path> tasks = Files.list(Paths.get(Objects.requireNonNull(TaskLogHome.getTaskLogsHome()), new String[0]));){
                    return tasks.map(Path::toFile).collect(Collectors.toSet());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.log.error("Unable to list files in the tasks directory", (Throwable)e);
                return Collections.emptySet();
            }
        }
        if (fileName.startsWith("replication/") && fileName.endsWith(".log")) {
            try {
                Throwable e = null;
                Object var3_10 = null;
                try (Stream<Path> tasks = Files.list(Paths.get(TaskLogHome.getReplicationLogsHome().orElse("replication/"), new String[0]));){
                    return tasks.map(Path::toFile).collect(Collectors.toSet());
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                this.log.error("Unable to list files in the replication directory", (Throwable)e);
                return Collections.emptySet();
            }
        }
        return this.getLogFiles();
    }

    public final boolean isValidLogFile(Path path) {
        boolean isValid = path.getFileName().toString().toLowerCase().endsWith(".log");
        if (this.log.isDebugEnabled() && !isValid) {
            this.log.debug("File {} skipped as not valid log file", (Object)path.getFileName().toString());
        }
        return isValid;
    }

    public Map<String, LoggerLevel> getEffectiveLoggersUpdatedByFetchedOverrides() {
        Map<String, LoggerLevel> loggersOverrides = this.overrides.syncWithDBAndGet();
        Map<String, LoggerLevel> loggers = this.getLoggers();
        if (Objects.isNull(loggersOverrides) || loggersOverrides.isEmpty()) {
            return loggers;
        }
        loggers.putAll(loggersOverrides);
        return loggers;
    }

    private static class CustomizerMediator
    implements Mediator<Named, LogConfigurationCustomizer, LogbackLogManager> {
        private CustomizerMediator() {
        }

        public void add(BeanEntry<Named, LogConfigurationCustomizer> entry, LogbackLogManager watcher) {
            watcher.registerCustomization((LogConfigurationCustomizer)entry.getValue());
        }

        public void remove(BeanEntry<Named, LogConfigurationCustomizer> entry, LogbackLogManager watcher) {
        }
    }
}

