/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.log;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.log.LogManager;
import org.sonatype.nexus.common.log.LogMarkInsertedEvent;
import org.sonatype.nexus.common.log.LogMarker;
import org.sonatype.nexus.common.log.LoggerLevel;

@Named
@Singleton
public class LogMarkerImpl
extends ComponentSupport
implements LogMarker {
    private final LogManager logManager;
    private final EventManager eventManager;

    @Inject
    public LogMarkerImpl(LogManager logManager, EventManager eventManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    public void markLog(String message) {
        LoggerLevel loggerLevel = this.logManager.getLoggerEffectiveLevel(this.log.getName());
        if (LoggerLevel.INFO.compareTo((Enum)loggerLevel) < 0) {
            this.logManager.setLoggerLevel(this.log.getName(), LoggerLevel.INFO);
        }
        String asterixes = Strings.repeat((String)"*", (int)(message.length() + 4));
        this.log.info("\n{}\n* {} *\n{}", new Object[]{asterixes, message, asterixes});
        this.eventManager.post((Object)new LogMarkInsertedEvent(message));
    }
}

