/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.commands;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;

@Named
@Command(name="lifecyclePhase", scope="nexus", description="Move the Nexus application lifecycle to the given phase")
public class LifecyclePhaseAction
implements Action {
    private final ManagedLifecycleManager lifecycleManager;
    @Argument(description="The phase to move to")
    ManagedLifecycle.Phase phase;

    @Inject
    public LifecyclePhaseAction(ManagedLifecycleManager lifecycleManager) {
        this.lifecycleManager = (ManagedLifecycleManager)Preconditions.checkNotNull((Object)lifecycleManager);
    }

    public Object execute() throws Exception {
        if (this.phase != null) {
            this.lifecycleManager.to(this.phase);
        }
        return this.lifecycleManager.getCurrentPhase().name();
    }
}

