/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;
import org.sonatype.nexus.internal.app.ManagedLifecycleResourceDoc;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Path(value="/v1/lifecycle")
@Named
@Singleton
public class ManagedLifecycleResource
extends ComponentSupport
implements Resource,
ManagedLifecycleResourceDoc {
    public static final String RESOURCE_URI = "/v1/lifecycle";
    private final ManagedLifecycleManager lifecycleManager;

    @Inject
    public ManagedLifecycleResource(ManagedLifecycleManager lifecycleManager) {
        this.lifecycleManager = (ManagedLifecycleManager)Preconditions.checkNotNull((Object)lifecycleManager);
    }

    @Override
    @GET
    @Path(value="phase")
    @Produces(value={"text/plain"})
    public String getPhase() {
        return this.lifecycleManager.getCurrentPhase().name();
    }

    @Override
    @PUT
    @Path(value="phase")
    @Consumes(value={"text/plain"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void setPhase(String phase) {
        try {
            this.lifecycleManager.to(ManagedLifecycle.Phase.valueOf((String)phase));
        }
        catch (Exception e) {
            this.log.warn("Problem moving to phase {}", (Object)phase, (Object)e);
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, "Problem moving to phase " + phase + ": " + e);
        }
    }

    @Override
    @PUT
    @Path(value="bounce")
    @Consumes(value={"text/plain"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void bounce(String phase) {
        try {
            this.lifecycleManager.bounce(ManagedLifecycle.Phase.valueOf((String)phase));
        }
        catch (Exception e) {
            this.log.warn("Problem bouncing phase {}", (Object)phase, (Object)e);
            throw new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, "Problem bouncing phase " + phase + ": " + e);
        }
    }
}

