/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.Freezable;
import org.sonatype.nexus.common.app.FreezeRequest;
import org.sonatype.nexus.common.app.FreezeService;
import org.sonatype.nexus.common.app.FrozenException;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.security.ClientInfo;
import org.sonatype.nexus.security.ClientInfoProvider;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Singleton
public class LocalFreezeService
extends StateGuardLifecycleSupport
implements FreezeService {
    private static final String MARKER_FILE = "frozen.marker";
    private final ObjectMapper mapper = new ObjectMapper();
    private final List<FreezeRequest> freezeRequests = new CopyOnWriteArrayList<FreezeRequest>();
    private final File markerFile;
    private final ClientInfoProvider clientInfoProvider;
    private final List<Freezable> freezables;

    @Inject
    public LocalFreezeService(ApplicationDirectories directories, ClientInfoProvider clientInfoProvider, List<Freezable> freezables) {
        this.markerFile = new File(directories.getWorkDirectory("db"), MARKER_FILE);
        this.clientInfoProvider = (ClientInfoProvider)Preconditions.checkNotNull((Object)clientInfoProvider);
        this.freezables = (List)Preconditions.checkNotNull(freezables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        List<FreezeRequest> list = this.freezeRequests;
        synchronized (list) {
            if (this.loadUserFreezeRequest()) {
                this.freezables.forEach(this::tryFreeze);
            }
        }
    }

    public void requestFreeze(String reason) {
        this.addRequest(null, reason);
    }

    public void cancelFreeze() {
        this.removeRequest(null);
    }

    public void taskRequestFreeze(String token, String reason) {
        this.addRequest((String)Preconditions.checkNotNull((Object)token), reason);
    }

    public void taskCancelFreeze(String token) {
        this.removeRequest((String)Preconditions.checkNotNull((Object)token));
    }

    public List<FreezeRequest> cancelAllFreezeRequests() {
        List<FreezeRequest> canceledRequests = this.currentFreezeRequests();
        this.freezeRequests.clear();
        Lists.reverse(this.freezables).forEach(this::tryUnfreeze);
        return canceledRequests;
    }

    public boolean isFrozen() {
        return !this.freezeRequests.isEmpty();
    }

    public List<FreezeRequest> currentFreezeRequests() {
        return ImmutableList.copyOf(this.freezeRequests);
    }

    public void checkReadable(String errorMessage) {
    }

    public void checkWritable(String errorMessage) {
        if (this.isFrozen()) {
            throw new FrozenException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(@Nullable String token, String reason) {
        FreezeRequest request = this.newRequest(token, reason);
        List<FreezeRequest> list = this.freezeRequests;
        synchronized (list) {
            Preconditions.checkState((!Iterables.any(this.freezeRequests, LocalFreezeService.sameToken(token)) ? 1 : 0) != 0, (Object)"Freeze has already been requested");
            if (token == null) {
                this.saveUserFreezeRequest(request);
            }
            this.freezeRequests.add(request);
            if (this.freezeRequests.size() == 1) {
                this.freezables.forEach(this::tryFreeze);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRequest(@Nullable String token) {
        if (token == null) {
            this.deleteUserFreezeRequest();
        }
        List<FreezeRequest> list = this.freezeRequests;
        synchronized (list) {
            Preconditions.checkState((boolean)this.freezeRequests.removeIf((Predicate<FreezeRequest>)LocalFreezeService.sameToken(token)), (Object)"Cannot find freeze request to cancel");
            if (this.freezeRequests.size() == 0) {
                Lists.reverse(this.freezables).forEach(this::tryUnfreeze);
            }
        }
    }

    private FreezeRequest newRequest(@Nullable String token, String reason) {
        Optional<ClientInfo> clientInfo = Optional.ofNullable(this.clientInfoProvider.getCurrentThreadClientInfo());
        return new FreezeRequest(token, reason, DateTime.now((DateTimeZone)DateTimeZone.UTC), (String)clientInfo.map(ClientInfo::getUserid).orElse(null), (String)clientInfo.map(ClientInfo::getRemoteIP).orElse(null));
    }

    private static com.google.common.base.Predicate<FreezeRequest> sameToken(@Nullable String token) {
        Optional<String> optionalToken = Optional.ofNullable(token);
        return request -> optionalToken.equals(request.token());
    }

    private void tryFreeze(Freezable freezable) {
        try {
            freezable.freeze();
        }
        catch (Exception e) {
            this.log.warn("Problem freezing {}", (Object)freezable, (Object)e);
        }
    }

    private void tryUnfreeze(Freezable freezable) {
        try {
            freezable.unfreeze();
        }
        catch (Exception e) {
            this.log.warn("Problem unfreezing {}", (Object)freezable, (Object)e);
        }
    }

    private boolean loadUserFreezeRequest() {
        if (this.markerFile.exists()) {
            FreezeRequest request;
            JsonNode json;
            block4: {
                json = this.mapper.readTree(this.markerFile);
                if (json.size() != 0) break block4;
                return false;
            }
            try {
                request = new FreezeRequest(null, json.path("reason").asText(), DateTime.parse((String)json.path("frozenAt").asText()), json.path("frozenBy").asText(), json.path("frozenByIp").asText());
            }
            catch (Exception e) {
                this.log.debug("Problem parsing frozen.marker, will add placeholder request", (Throwable)e);
                request = new FreezeRequest(null, MARKER_FILE, DateTime.now((DateTimeZone)DateTimeZone.UTC), null, null);
            }
            this.freezeRequests.add(request);
            return this.freezeRequests.size() == 1;
        }
        return false;
    }

    private void saveUserFreezeRequest(FreezeRequest request) {
        try {
            ImmutableMap json = ImmutableMap.of((Object)"reason", (Object)request.reason(), (Object)"frozenAt", (Object)request.frozenAt().toString(), (Object)"frozenBy", request.frozenBy().orElse(null), (Object)"frozenByIp", request.frozenByIp().orElse(null));
            this.mapper.writeValue(this.markerFile, (Object)json);
        }
        catch (Exception e) {
            this.log.warn("Cannot save frozen.marker", (Throwable)e);
        }
    }

    private void deleteUserFreezeRequest() {
        if (this.markerFile.exists()) {
            try {
                Files.delete(this.markerFile.toPath());
            }
            catch (Exception e) {
                this.log.warn("Cannot delete frozen.marker", (Throwable)e);
            }
        }
    }
}

