/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.app.BaseUrlManager;

@Named
@Singleton
public class BaseUrlManagerImpl
extends ComponentSupport
implements BaseUrlManager {
    private final Provider<HttpServletRequest> requestProvider;
    private volatile String url;
    private volatile boolean force;

    @Inject
    public BaseUrlManagerImpl(Provider<HttpServletRequest> requestProvider, @Named(value="${org.sonatype.nexus.internal.app.BaseUrlManagerImpl.force:-false}") @Named(value="${org.sonatype.nexus.internal.app.BaseUrlManagerImpl.force:-false}") boolean force) {
        this.requestProvider = (Provider)Preconditions.checkNotNull(requestProvider);
        this.force = force;
        this.log.debug("Force: {}", (Object)force);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Nullable
    private HttpServletRequest httpRequest() {
        try {
            return (HttpServletRequest)this.requestProvider.get();
        }
        catch (Exception e) {
            this.log.trace("Unable to resolve HTTP servlet-request", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public String detectUrl() {
        if (this.force && !Strings.isNullOrEmpty((String)this.url)) {
            return this.url;
        }
        HttpServletRequest request = this.httpRequest();
        if (request != null) {
            StringBuffer url = request.getRequestURL();
            String uri = request.getRequestURI();
            String ctx = request.getContextPath();
            return url.substring(0, url.length() - uri.length() + ctx.length());
        }
        if (!Strings.isNullOrEmpty((String)this.url)) {
            return this.url;
        }
        return null;
    }

    @Nullable
    public String detectRelativePath() {
        HttpServletRequest request = this.httpRequest();
        if (request != null) {
            String contextPath = null;
            String requestUri = null;
            if (DispatcherType.FORWARD == request.getDispatcherType()) {
                contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
                requestUri = (String)request.getAttribute("javax.servlet.forward.request_uri");
            } else if (DispatcherType.ERROR == request.getDispatcherType()) {
                requestUri = (String)request.getAttribute("javax.servlet.error.request_uri");
            }
            contextPath = contextPath == null ? request.getContextPath() : contextPath;
            requestUri = requestUri == null ? request.getRequestURI() : requestUri;
            String path = requestUri.substring(contextPath.length());
            return BaseUrlManagerImpl.createRelativePath(BaseUrlManagerImpl.countSlashes(path));
        }
        return "";
    }

    private static String createRelativePath(int length) {
        if (length == 0) {
            return ".";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length) {
            sb.append("../");
            ++i;
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static int countSlashes(String path) {
        int count = 0;
        int previousIndex = 0;
        int i = 1;
        while (i < path.length()) {
            if (path.charAt(i) == '/') {
                if (previousIndex != i - 1) {
                    ++count;
                }
                previousIndex = i;
            }
            ++i;
        }
        return count;
    }

    public void detectAndHoldUrl() {
        String url = this.detectUrl();
        if (url != null) {
            BaseUrlHolder.set((String)url, (String)this.detectRelativePath());
        }
    }
}

