/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.io.DirectoryHelper;

@Named
@Singleton
public class ApplicationDirectoriesImpl
extends ComponentSupport
implements ApplicationDirectories {
    private final File installDir;
    private final File configDir;
    private final File workDir;
    private final File tempDir;

    @Inject
    public ApplicationDirectoriesImpl(@Named(value="${karaf.base}") @Named(value="${karaf.base}") File installDir, @Named(value="${karaf.data}") @Named(value="${karaf.data}") File workDir) {
        this.installDir = this.resolve(installDir, false);
        this.log.debug("Install dir: {}", (Object)this.installDir);
        this.configDir = this.resolve(new File(installDir, "etc"), false);
        this.log.debug("Config dir: {}", (Object)this.configDir);
        this.workDir = this.resolve(workDir, true);
        this.log.debug("Work dir: {}", (Object)this.workDir);
        String tmplocation = System.getProperty("java.io.tmpdir", "tmp");
        this.tempDir = this.resolve(new File(tmplocation), true);
        this.log.debug("Temp dir: {}", (Object)this.tempDir);
    }

    public File getInstallDirectory() {
        return this.installDir;
    }

    public File getConfigDirectory(String subsystem) {
        Preconditions.checkNotNull((Object)subsystem);
        return new File(this.configDir, subsystem);
    }

    public File getTemporaryDirectory() {
        return this.tempDir;
    }

    public File getWorkDirectory() {
        return this.workDir;
    }

    public File getWorkDirectory(String path, boolean create) {
        Preconditions.checkNotNull((Object)path);
        File dir = new File(path);
        if (!dir.isAbsolute()) {
            dir = new File(this.getWorkDirectory(), path);
        }
        return this.resolve(dir, create);
    }

    public File getWorkDirectory(String path) {
        return this.getWorkDirectory(path, true);
    }

    private void mkdir(File dir) {
        if (dir.isDirectory()) {
            return;
        }
        try {
            DirectoryHelper.mkdir((Path)dir.toPath());
            this.log.debug("Created directory: {}", (Object)dir);
        }
        catch (Exception e) {
            this.log.error("Failed to create directory: {}", (Object)dir);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private File resolve(File dir, boolean create) {
        Preconditions.checkNotNull((Object)dir);
        this.log.trace("Resolving directory: {}; create: {}", (Object)dir, (Object)create);
        try {
            dir = dir.getCanonicalFile();
        }
        catch (Exception e) {
            this.log.error("Failed to canonicalize directory: {}", (Object)dir);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        if (create) {
            this.mkdir(dir);
        }
        return dir;
    }
}

