/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.net.PercentEscaper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

final class PercentEncoding {
    private static final String UTF_8 = Charsets.UTF_8.name();
    private static final PercentEscaper ESCAPER = new PercentEscaper("-_.~:/", false);
    private static final PercentEscaper NAME_ESCAPER = new PercentEscaper("-_.~:", false);

    private PercentEncoding() {
    }

    public static String encode(String value) {
        Preconditions.checkNotNull((Object)value);
        return ESCAPER.escape(value);
    }

    public static String encodeName(String value) {
        Preconditions.checkNotNull((Object)value);
        return NAME_ESCAPER.escape(value);
    }

    public static String encodeVersion(String value) {
        return PercentEncoding.encode(value);
    }

    public static String encodeSegment(String value) {
        return PercentEncoding.encode(value);
    }

    public static String encodeQualifierValue(String value) {
        return PercentEncoding.encode(value);
    }

    public static String decode(String value) {
        Preconditions.checkNotNull((Object)value);
        try {
            return URLDecoder.decode(value, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

