/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sonatype.nexus.crowd.Crowd;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.security.SecuritySystem;

@Singleton
@Typed(value={Realm.class})
@Named(value="Crowd")
@Description(value="Crowd Realm")
public class CrowdRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(CrowdRealm.class);
    public static final String NAME = "Crowd";
    private final Crowd crowd;
    private final SecuritySystem securitySystem;
    private final String licenseAccessPermission;
    private final LicenseFeatureVerifier licenseVerifier;
    private final Feature feature;

    @Inject
    public CrowdRealm(Crowd crowd, SecuritySystem securitySystem, @Named(value="${license-access-permission:-nexus:*}") @Named(value="${license-access-permission:-nexus:*}") String licenseAccessPermission, LicenseFeatureVerifier licenseVerifier, @Named(value="crowd") @Named(value="crowd") Feature feature) {
        this.crowd = (Crowd)Preconditions.checkNotNull((Object)crowd);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.licenseAccessPermission = (String)Preconditions.checkNotNull((Object)licenseAccessPermission);
        this.licenseVerifier = (LicenseFeatureVerifier)Preconditions.checkNotNull((Object)licenseVerifier);
        this.feature = (Feature)Preconditions.checkNotNull((Object)feature);
        this.setName(NAME);
        this.setAuthenticationCachingEnabled(true);
        this.setAuthorizationCachingEnabled(true);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) {
        if (!(authenticationToken instanceof UsernamePasswordToken)) {
            throw new UnsupportedTokenException("Token of type " + authenticationToken.getClass().getName() + " is not " + "supported.  A " + UsernamePasswordToken.class.getName() + " is required.");
        }
        UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
        try {
            User user = this.crowd.client().authenticateUser(token.getUsername(), new String(token.getPassword()));
            SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)user.getName(), token.getCredentials(), this.getName());
            try {
                this.licenseVerifier.verifyLicenseAndFeature(this.feature);
            }
            catch (LicensingException e) {
                block13: {
                    try {
                        if (this.securitySystem.isPermitted(info.getPrincipals(), this.licenseAccessPermission)) {
                            return info;
                        }
                    }
                    catch (Throwable e1) {
                        if (log.isDebugEnabled()) {
                            log.error("Failed to lookup user '{}'.  Invalid license in place anyway.", (Object)token.getUsername(), (Object)e1);
                            break block13;
                        }
                        log.error("Failed to lookup user '{}' due to {}/{}.  Invalid license in place anyway.", new Object[]{token.getUsername(), e1.getClass().getName(), e1.getMessage()});
                    }
                }
                throw new LockedAccountException("Unable to login due to license limitation", (Throwable)e);
            }
            return info;
        }
        catch (UserNotFoundException e) {
            throw new UnknownAccountException((Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new IncorrectCredentialsException((Throwable)e);
        }
        catch (InactiveAccountException e) {
            throw new DisabledAccountException((Throwable)e);
        }
        catch (ExpiredCredentialException e) {
            throw new ExpiredCredentialsException("User credentials have expired for user: " + token.getUsername(), (Throwable)e);
        }
        catch (Exception e) {
            CrowdRealm.logError(log, "Could not authenticate user '" + token.getUsername() + "' with Crowd", e);
            throw new AuthenticationException("Could not authenticate user '" + token.getUsername() + "' with Crowd", (Throwable)e);
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (!principals.getRealmNames().contains(this.getName())) {
            return null;
        }
        String userId = principals.getPrimaryPrincipal().toString();
        try {
            return new SimpleAuthorizationInfo((Set)Sets.newHashSet((Iterable)this.crowd.client().getNamesOfGroupsForNestedUser(userId, 0, Integer.MAX_VALUE)));
        }
        catch (ApplicationPermissionException | OperationFailedException e) {
            CrowdRealm.logError(log, "Could not retrieve authorization info from Crowd for '" + userId + "'", e);
        }
        catch (Exception e) {
            CrowdRealm.logWarning(log, "Could not retrieve authorization info from Crowd for '" + userId + "'", e);
        }
        return null;
    }

    public void clearCache(PrincipalCollection principals) {
        super.clearCache(principals);
    }

    static void logError(Logger log, String message, Throwable t) {
        if (log.isDebugEnabled()) {
            log.error(message, t);
        } else {
            log.error(String.valueOf(message) + " due to {}/{}", (Object)t.getClass().getName(), (Object)t.getMessage());
        }
    }

    static void logWarning(Logger log, String message, Throwable t) {
        if (log.isDebugEnabled()) {
            log.warn(message, t);
        } else {
            log.warn(String.valueOf(message) + " due to {}/{}", (Object)t.getClass().getName(), (Object)t.getMessage());
        }
    }
}

