/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.validation.constraint.UrlString;

public class CrowdConfiguration
extends CapabilityConfigurationSupport {
    public static final String APPLICATION_NAME = "applicationName";
    public static final String APPLICATION_PASSWORD = "applicationPassword";
    public static final String CROWD_SERVER_URL = "crowdServerUrl";
    public static final String HTTP_TIMEOUT = "httpTimeout";
    public static final String USE_TRUST_STORE = "useTrustStore";
    @NotBlank
    private String applicationName;
    @NotBlank
    private String applicationPassword;
    @NotBlank
    @UrlString
    private String crowdServerUrl;
    @Min(value=0L)
    private @Min(value=0L) Integer httpTimeout;
    private boolean useTrustStore;

    public CrowdConfiguration() {
    }

    public CrowdConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.applicationName = properties.get(APPLICATION_NAME);
        this.applicationPassword = properties.get(APPLICATION_PASSWORD);
        this.crowdServerUrl = properties.get(CROWD_SERVER_URL);
        this.httpTimeout = this.parseInteger(properties.get(HTTP_TIMEOUT), null);
        this.useTrustStore = this.parseBoolean(properties.get(USE_TRUST_STORE), false);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public CrowdConfiguration withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public CrowdConfiguration withApplicationPassword(String applicationPassword) {
        this.applicationPassword = applicationPassword;
        return this;
    }

    public String getCrowdServerUrl() {
        return this.crowdServerUrl;
    }

    public CrowdConfiguration withCrowdServerUrl(String url) {
        this.crowdServerUrl = url;
        return this;
    }

    public Integer getHttpTimeout() {
        return this.httpTimeout;
    }

    public CrowdConfiguration withHttpTimeout(Integer httpTimeout) {
        this.httpTimeout = httpTimeout;
        return this;
    }

    public boolean getUseTrustStore() {
        return this.useTrustStore;
    }

    public CrowdConfiguration withUseTrustStore(boolean useTrustStore) {
        this.useTrustStore = useTrustStore;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap map = Maps.newHashMap();
        map.put(APPLICATION_NAME, this.applicationName);
        map.put(APPLICATION_PASSWORD, this.applicationPassword);
        map.put(CROWD_SERVER_URL, this.crowdServerUrl);
        if (this.httpTimeout != null) {
            map.put(HTTP_TIMEOUT, String.valueOf(this.httpTimeout));
        }
        map.put(USE_TRUST_STORE, String.valueOf(this.useTrustStore));
        return map;
    }

    public Properties getCrowdClientProperties() {
        Properties props = new Properties();
        props.setProperty("application.name", this.applicationName);
        props.setProperty("application.password", this.applicationPassword);
        props.setProperty("crowd.server.url", this.crowdServerUrl);
        if (this.httpTimeout != null) {
            props.setProperty("http.timeout", String.valueOf(this.httpTimeout));
        }
        props.setProperty(USE_TRUST_STORE, String.valueOf(this.useTrustStore));
        return props;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "applicationName=" + this.applicationName + ", applicationPassword=" + Strings2.mask((String)this.applicationPassword) + ", crowdServerUrl=" + this.crowdServerUrl + ", httpTimeout=" + this.httpTimeout + ", useTrustStore=" + this.useTrustStore + '}';
    }
}

