/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.security;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.script.plugin.internal.security.ScriptPrivilegeDescriptor;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;
import org.sonatype.nexus.security.config.memory.MemoryCPrivilege;

@Named
@Singleton
public class ScriptSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    public static final String SCRIPT_ALL_PREFIX = "nx-script-*-";
    public static final String SCRIPT_ALL_DESCRIPTION_SUFFIX = " permissions for Scripts";
    public static final String ACTION_BROWSE = "browse";
    public static final String ACTION_READ = "read";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_RUN = "run";

    public SecurityConfiguration getContribution() {
        MemorySecurityConfiguration config = new MemorySecurityConfiguration();
        config.addPrivilege((CPrivilege)this.createScriptPrivilege("*"));
        config.addPrivilege((CPrivilege)this.createScriptPrivilege(ACTION_BROWSE));
        config.addPrivilege((CPrivilege)this.createScriptPrivilege(ACTION_READ));
        config.addPrivilege((CPrivilege)this.createScriptPrivilege(ACTION_EDIT));
        config.addPrivilege((CPrivilege)this.createScriptPrivilege(ACTION_ADD));
        config.addPrivilege((CPrivilege)this.createScriptPrivilege(ACTION_DELETE));
        config.addPrivilege((CPrivilege)this.createScriptPrivilege(ACTION_RUN));
        return config;
    }

    private MemoryCPrivilege createScriptPrivilege(String action) {
        String id = SCRIPT_ALL_PREFIX + action;
        String description = String.valueOf("*".equals(action) ? "All" : StringUtils.capitalize((String)action)) + SCRIPT_ALL_DESCRIPTION_SUFFIX;
        String actions = "*".equals(action) || ACTION_READ.equals(action) || ACTION_RUN.equals(action) ? action : String.join((CharSequence)",", action, ACTION_READ);
        return new MemoryCPrivilege.MemoryCPrivilegeBuilder(id).type(ScriptPrivilegeDescriptor.TYPE).readOnly(true).name(id).description(description).property("name", "*").property("actions", actions).build();
    }
}

