/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.rest;

import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.script.plugin.internal.rest.ApiPrivilegeScriptRequest;
import org.sonatype.nexus.script.plugin.internal.rest.ScriptPrivilegeApiResourceDoc;
import org.sonatype.nexus.script.plugin.internal.security.ScriptPrivilegeDescriptor;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptor;
import org.sonatype.nexus.security.privilege.rest.ApiPrivilegeRequest;
import org.sonatype.nexus.security.privilege.rest.PrivilegeApiResourceSupport;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ScriptPrivilegeApiResource
extends PrivilegeApiResourceSupport
implements Resource,
ScriptPrivilegeApiResourceDoc {
    @Inject
    public ScriptPrivilegeApiResource(SecuritySystem securitySystem, Map<String, PrivilegeDescriptor> privilegeDescriptors) {
        super(securitySystem, privilegeDescriptors);
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:privileges:create"})
    @Path(value="script")
    public Response createPrivilege(ApiPrivilegeScriptRequest privilege) {
        return this.doCreate(ScriptPrivilegeDescriptor.TYPE, (ApiPrivilegeRequest)privilege);
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:privileges:update"})
    @Path(value="script/{privilegeName}")
    public void updatePrivilege(@PathParam(value="privilegeName") String privilegeName, ApiPrivilegeScriptRequest privilege) {
        this.doUpdate(privilegeName, ScriptPrivilegeDescriptor.TYPE, (ApiPrivilegeRequest)privilege);
    }
}

