/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.rest;

import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import javax.validation.constraints.NotBlank;
import org.sonatype.nexus.script.plugin.internal.security.ScriptPrivilegeDescriptor;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.privilege.rest.ApiPrivilegeWithActions;
import org.sonatype.nexus.security.privilege.rest.PrivilegeAction;

public class ApiPrivilegeScript
extends ApiPrivilegeWithActions {
    public static final String SCRIPT_KEY = "name";
    @NotBlank
    @ApiModelProperty(value="The name of a script to give access to.")
    private String scriptName;

    private ApiPrivilegeScript() {
        super(ScriptPrivilegeDescriptor.TYPE);
    }

    public ApiPrivilegeScript(String name, String description, boolean readOnly, String scriptName, Collection<PrivilegeAction> actions) {
        super(ScriptPrivilegeDescriptor.TYPE, name, description, readOnly, actions);
        this.scriptName = scriptName;
    }

    public ApiPrivilegeScript(Privilege privilege) {
        super(privilege);
        this.scriptName = privilege.getPrivilegeProperty(SCRIPT_KEY);
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    protected Privilege doAsPrivilege(Privilege privilege) {
        super.doAsPrivilege(privilege);
        privilege.addProperty(SCRIPT_KEY, this.scriptName);
        return privilege;
    }

    protected String doAsActionString() {
        return this.toBreadRunActionString();
    }
}

