/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.plugin.internal.ScriptStore;
import org.sonatype.nexus.script.plugin.internal.orient.OrientScript;
import org.sonatype.nexus.script.plugin.internal.orient.OrientScriptEntityAdapter;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientScriptStore
extends StateGuardLifecycleSupport
implements ScriptStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientScriptEntityAdapter entityAdapter;

    @Inject
    public OrientScriptStore(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientScriptEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientScriptEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Script newScript() {
        return new OrientScript();
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Script> list() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    @Nullable
    public Script get(String name) {
        for (Script script : this.list()) {
            if (!Objects.equals(script.getName(), name)) continue;
            return script;
        }
        return null;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void create(Script script) {
        Preconditions.checkNotNull((Object)script);
        Preconditions.checkArgument((boolean)(script instanceof OrientScript), (Object)"Script is not an OrientScript");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)((OrientScript)script));
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(Script script) {
        Preconditions.checkNotNull((Object)script);
        Preconditions.checkArgument((boolean)(script instanceof OrientScript), (Object)"Script is not an OrientScript");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.editEntity(db, (Entity)((OrientScript)script));
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(Script script) {
        Preconditions.checkNotNull((Object)script);
        Preconditions.checkArgument((boolean)(script instanceof OrientScript), (Object)"Script is not an OrientScript");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)((OrientScript)script)));
    }
}

