/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal;

import com.codahale.metrics.health.HealthCheck;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.script.ScriptManager;

@Named(value="Scripting")
@Singleton
public class ScriptPluginHealthCheck
extends HealthCheck {
    public static final String SCRIPTING_DISABLED_MESSAGE = "Scripting is disabled.";
    public static final String SCRIPTING_ENABLED_ERROR = "Enabling and running scripts is not recommended as this bypasses security checks and can cause your Nexus instance to be vulnerable to existing and future attacks. We recommend using alternate ways to automate the configuration of this instance where possible.";
    private final ScriptManager scriptManager;

    @Inject
    public ScriptPluginHealthCheck(ScriptManager scriptManager) {
        this.scriptManager = scriptManager;
    }

    protected HealthCheck.Result check() {
        return this.scriptManager.isEnabled() ? HealthCheck.Result.unhealthy((String)SCRIPTING_ENABLED_ERROR) : HealthCheck.Result.healthy((String)SCRIPTING_DISABLED_MESSAGE);
    }
}

