/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.plugin.internal.ScriptData;
import org.sonatype.nexus.script.plugin.internal.ScriptStore;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="scriptExport")
@Singleton
public class ScriptExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final ScriptStore store;

    @Inject
    public ScriptExport(ScriptStore store) {
        this.store = store;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export Script data to {}", (Object)file);
        List<Script> scripts = this.store.list();
        this.exportToJson(scripts, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring Script data from {}", (Object)file);
        this.importFromJson(file, ScriptData.class).forEach(this.store::create);
    }
}

