/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal.proxy;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.HelmFormat;
import com.sonatype.repository.helm.internal.metadata.IndexYamlAbsoluteUrlRewriter;
import com.sonatype.repository.helm.internal.util.HelmAttributeParser;
import com.sonatype.repository.helm.internal.util.HelmPathUtils;
import com.sonatype.repository.helm.orient.internal.HelmFacet;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class HelmProxyFacetImpl
extends ProxyFacetSupport {
    private final HelmPathUtils helmPathUtils;
    private final HelmAttributeParser helmAttributeParser;
    private final IndexYamlAbsoluteUrlRewriter indexYamlRewriter;
    private HelmFacet helmFacet;
    private static final String INDEX_YAML = "index.yaml";

    @Inject
    public HelmProxyFacetImpl(HelmPathUtils helmPathUtils, HelmAttributeParser helmAttributeParser, IndexYamlAbsoluteUrlRewriter indexYamlAbsoluteUrlRewriter) {
        this.helmPathUtils = (HelmPathUtils)((Object)Preconditions.checkNotNull((Object)((Object)helmPathUtils)));
        this.helmAttributeParser = (HelmAttributeParser)Preconditions.checkNotNull((Object)helmAttributeParser);
        this.indexYamlRewriter = (IndexYamlAbsoluteUrlRewriter)((Object)Preconditions.checkNotNull((Object)((Object)indexYamlAbsoluteUrlRewriter)));
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.helmFacet = (HelmFacet)this.facet(HelmFacet.class);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
    }

    @Nullable
    protected Content getCachedContent(Context context) {
        Content content = this.getAsset(this.getAssetPath(context));
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return assetKind == AssetKind.HELM_INDEX ? this.indexYamlRewriter.removeUrlsFromIndexYaml(content) : content;
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case HELM_INDEX: {
                return this.putMetadata(this.getAssetPath(context), content, assetKind);
            }
            case HELM_PACKAGE: {
                return this.putComponent(content, this.getAssetPath(context), assetKind);
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }

    private Content putMetadata(String path, Content content, AssetKind assetKind) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), HelmFormat.HASH_ALGORITHMS);){
            this.saveMetadataAsAsset(path, tempBlob, (Payload)content, assetKind);
            return this.indexYamlRewriter.removeUrlsFromIndexYaml(tempBlob, content.getAttributes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content saveMetadataAsAsset(String assetPath, TempBlob metadataContent, Payload payload, AssetKind assetKind) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        HelmAttributes chart = new HelmAttributes(Collections.emptyMap());
        Asset asset = this.helmFacet.findOrCreateAsset(tx, assetPath, assetKind, chart);
        return this.helmFacet.saveAsset(tx, asset, metadataContent, payload);
    }

    /*
     * Loose catch block
     */
    private Content putComponent(Content content, String fileName, AssetKind assetKind) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Content content2;
            InputStream in;
            TempBlob tempBlob;
            block16: {
                block15: {
                    tempBlob = storageFacet.createTempBlob(content.openInputStream(), HelmFormat.HASH_ALGORITHMS);
                    in = tempBlob.get();
                    HelmAttributes helmAttributes = this.helmAttributeParser.getAttributes(assetKind, in);
                    content2 = this.doCreateOrSaveComponent(helmAttributes, fileName, assetKind, tempBlob, content.getContentType(), content.getAttributes());
                    if (in == null) break block15;
                    in.close();
                }
                if (tempBlob == null) break block16;
                tempBlob.close();
            }
            return content2;
            {
                catch (Throwable throwable2) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doCreateOrSaveComponent(HelmAttributes helmAttributes, String fileName, AssetKind assetKind, TempBlob componentContent, String contentType, AttributesMap contentAttributes) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.helmFacet.findOrCreateAsset(tx, fileName, assetKind, helmAttributes);
        return this.helmFacet.saveAsset(tx, asset, componentContent, contentType, contentAttributes);
    }

    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Optional<Asset> assetOpt = this.helmFacet.findAsset(tx, name);
        if (!assetOpt.isPresent()) {
            return null;
        }
        Asset asset = assetOpt.get();
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        return this.helmFacet.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) {
        this.setCacheInfo(content, cacheInfo);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent Helm asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    private String getAssetPath(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case HELM_INDEX: {
                return INDEX_YAML;
            }
            case HELM_PACKAGE: {
                TokenMatcher.State matcherState = this.helmPathUtils.matcherState(context);
                return this.helmPathUtils.contentFilePath(matcherState, false);
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }

    protected String getUrl(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case HELM_INDEX: {
                return INDEX_YAML;
            }
            case HELM_PACKAGE: {
                TokenMatcher.State matcherState = this.helmPathUtils.matcherState(context);
                Optional<Content> indexOpt = Optional.ofNullable(this.getAsset(INDEX_YAML));
                if (!indexOpt.isPresent()) {
                    this.log.info("Try to refetch index.yml file in repository: {}", (Object)this.getRepository().getName());
                    indexOpt = this.fetchIndexYamlContext(context);
                }
                if (!indexOpt.isPresent()) {
                    this.log.error("index.yml file is absent in repository: {}", (Object)this.getRepository().getName());
                    return null;
                }
                String filename = this.helmPathUtils.filename(matcherState);
                return this.helmPathUtils.contentFileUrl(filename, indexOpt.get()).orElse(this.getRequestUrl(context));
            }
        }
        throw new IllegalStateException("Received an invalid AssetKind of type: " + assetKind.name());
    }

    private String getRequestUrl(@Nonnull Context context) {
        return StringUtils.removeStart((String)context.getRequest().getPath(), (String)"/");
    }

    private Optional<Content> fetchIndexYamlContext(@Nonnull Context context) {
        Context indexYamlContext = this.buildContextForRepositoryIndexYaml(context);
        try {
            this.get(indexYamlContext);
            return Optional.ofNullable(this.getAsset(INDEX_YAML));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Context buildContextForRepositoryIndexYaml(Context contextPackage) {
        Repository repository = contextPackage.getRepository();
        Request request = new Request.Builder().action(contextPackage.getRequest().getAction()).path(INDEX_YAML).build();
        Context indexYamlContext = new Context(repository, request);
        indexYamlContext.getAttributes().backing().putAll(contextPackage.getAttributes().backing());
        indexYamlContext.getAttributes().set(AssetKind.class, (Object)AssetKind.HELM_INDEX);
        return indexYamlContext;
    }
}

