/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal.metadata;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.internal.HelmFormat;
import com.sonatype.repository.helm.internal.metadata.ChartIndex;
import com.sonatype.repository.helm.internal.util.YamlParser;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.thread.io.StreamCopier;

@Named
public class IndexYamlBuilder {
    private final YamlParser yamlParser;

    @Inject
    public IndexYamlBuilder(YamlParser yamlParser) {
        this.yamlParser = (YamlParser)((Object)Preconditions.checkNotNull((Object)((Object)yamlParser)));
    }

    public TempBlob build(ChartIndex index, StorageFacet storageFacet) {
        return (TempBlob)new StreamCopier(os -> this.readIntoYaml((OutputStream)os, index), is -> this.createTempBlob((InputStream)is, storageFacet)).read();
    }

    private void readIntoYaml(OutputStream os, ChartIndex index) {
        this.yamlParser.write(os, index);
    }

    private TempBlob createTempBlob(InputStream inputStream, StorageFacet storageFacet) {
        return storageFacet.createTempBlob(inputStream, HelmFormat.HASH_ALGORITHMS);
    }
}

