/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.HelmFormat;
import com.sonatype.repository.helm.orient.internal.HelmFacet;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
public class HelmFacetImpl
extends FacetSupport
implements HelmFacet {
    @Override
    public Asset findOrCreateAsset(StorageTx tx, String assetPath, AssetKind assetKind, HelmAttributes helmAttributes) {
        Optional<Asset> assetOpt = this.findAsset(tx, assetPath);
        return assetOpt.orElseGet(() -> this.createAsset(tx, assetPath, helmAttributes, assetKind));
    }

    private Asset createAsset(StorageTx tx, String assetPath, HelmAttributes helmAttributes, AssetKind assetKind) {
        Preconditions.checkNotNull((Object)((Object)assetKind));
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = CacheControllerHolder.METADATA.equals((Object)assetKind.getCacheType()) ? tx.createAsset(bucket, this.getRepository().getFormat()) : tx.createAsset(bucket, this.findOrCreateComponent(tx, bucket, helmAttributes.getName(), helmAttributes.getVersion()));
        asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
        helmAttributes.populate(asset.formatAttributes());
        asset.name(assetPath);
        tx.saveAsset(asset);
        return asset;
    }

    private Component findOrCreateComponent(StorageTx tx, Bucket bucket, String name, String version) {
        Optional<Component> componentOpt = this.findComponent(tx, name, version);
        if (!componentOpt.isPresent()) {
            Component component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(name)).version(version);
            tx.saveComponent(component);
            return component;
        }
        return componentOpt.get();
    }

    private Optional<Component> findComponent(StorageTx tx, String name, String version) {
        Query query = Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).build();
        return StreamSupport.stream(tx.findComponents(query, Collections.singletonList(this.getRepository())).spliterator(), false).findFirst();
    }

    @Override
    @Nullable
    public Iterable<Asset> browseComponentAssets(StorageTx tx, @Nullable AssetKind assetKind) {
        Query.Builder builder = Query.builder().where("component").isNotNull();
        if (assetKind != null) {
            builder.and("attributes.helm.asset_kind").eq((Object)assetKind.name());
        }
        Query query = builder.build();
        Bucket bucket = tx.findBucket(this.getRepository());
        return tx.browseAssets(query, bucket);
    }

    @Override
    public Optional<Asset> findAsset(StorageTx tx, String assetName) {
        if (assetName == null) {
            return Optional.empty();
        }
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = tx.findAssetWithProperty("name", (Object)assetName, bucket);
        return Optional.ofNullable(asset);
    }

    @Override
    @Nullable
    public Content saveAsset(StorageTx tx, Asset asset, TempBlob contentSupplier, Payload payload) {
        try {
            if (payload instanceof Content) {
                AttributesMap contentAttributes = ((Content)payload).getAttributes();
                String contentType = payload.getContentType();
                return this.saveAsset(tx, asset, contentSupplier, contentType, contentAttributes);
            }
            return this.saveAsset(tx, asset, contentSupplier, null, null);
        }
        catch (IOException ex) {
            this.log.warn("Could not set blob {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    @Override
    public Content saveAsset(StorageTx tx, Asset asset, TempBlob contentSupplier, @Nullable String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), (InputStreamSupplier)contentSupplier, HelmFormat.HASH_ALGORITHMS, null, contentType, false);
        asset.markAsDownloaded();
        tx.saveAsset(asset);
        return this.toContent(asset, assetBlob.getBlob());
    }

    @Override
    public Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HelmFormat.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }
}

