/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal;

import com.orientechnologies.common.concur.ONeedRetryException;
import java.util.Collections;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class HelmComponentMaintenanceFacet
extends DefaultComponentMaintenanceImpl {
    @Transactional(retryOn={ONeedRetryException.class})
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlobs) {
        Component component;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        tx.deleteAsset(asset, deleteBlobs);
        if (asset.componentId() != null && !tx.browseAssets(component = tx.findComponentInBucket(asset.componentId(), bucket)).iterator().hasNext()) {
            this.log.debug("Deleting component: {}", (Object)component);
            tx.deleteComponent(component, deleteBlobs);
        }
        return Collections.singleton(asset.name());
    }
}

