/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.orient.internal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;
import org.sonatype.nexus.repository.storage.MetadataNode;

@Named(value="helm")
@Singleton
public class HelmComponentDirector
extends ComponentSupport
implements ComponentDirector {
    private final BucketStore bucketStore;
    private final RepositoryManager repositoryManager;

    @Inject
    public HelmComponentDirector(BucketStore bucketStore, RepositoryManager repositoryManager) {
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(Component component, Repository destination) {
        return this.repositoryFor(component).isPresent();
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    private Optional<Repository> repositoryFor(Component component) {
        return Optional.of(component).map(MetadataNode::bucketId).map(arg_0 -> ((BucketStore)this.bucketStore).getById(arg_0)).map(Bucket::getRepositoryName).map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0));
    }
}

