/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.internal.metadata.ChartIndex;
import com.sonatype.repository.helm.internal.util.YamlObjectMapperFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class YamlParser
extends ComponentSupport {
    private final ObjectMapper mapper;
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    @Inject
    public YamlParser(YamlObjectMapperFactory yamlObjectMapperFactory) {
        this.mapper = yamlObjectMapperFactory.getObjectMapper();
    }

    public Map<String, Object> load(InputStream is) throws IOException {
        Preconditions.checkNotNull((Object)is);
        return (Map)this.mapper.readValue(is, MAP_TYPE_REFERENCE);
    }

    public String getYamlContent(ChartIndex index) {
        try {
            return this.mapper.writeValueAsString((Object)index);
        }
        catch (IOException ex) {
            this.log.error("Error in index.yaml", (Throwable)ex);
            return null;
        }
    }

    public void write(OutputStream os, ChartIndex index) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
                String result = this.getYamlContent(index);
                writer.write(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.log.error("Unable to write to OutputStream for index.yaml", (Throwable)ex);
        }
    }
}

