/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.yaml.snakeyaml.LoaderOptions;

@Named
@Singleton
public class YamlObjectMapperFactory
extends ComponentSupport {
    private final int yamlMaxBytes;

    @Inject
    public YamlObjectMapperFactory(@Named(value="${nexus.helm.yaml.max.bytes:-25165824}") @Named(value="${nexus.helm.yaml.max.bytes:-25165824}") int yamlMaxBytes) {
        this.yamlMaxBytes = yamlMaxBytes;
    }

    public ObjectMapper getObjectMapper() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(this.yamlMaxBytes);
        return new ObjectMapper((JsonFactory)YAMLFactory.builder().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS).loaderOptions(loaderOptions).build()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }
}

