/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.internal.metadata.ChartEntry;
import com.sonatype.repository.helm.internal.metadata.ChartIndex;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Content;

public class IndexYamlAbsoluteUrlRewriterSupport
extends ComponentSupport {
    private final ObjectMapper objectMapper;

    public IndexYamlAbsoluteUrlRewriterSupport(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateUrls(InputStream is, OutputStream os) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStreamReader reader = new InputStreamReader(is);
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter(os);){
                        ChartIndex chartIndex = (ChartIndex)this.objectMapper.readValue((Reader)reader, ChartIndex.class);
                        chartIndex.getEntries().values().stream().flatMap(Collection::stream).forEach(this::rewriteUrls);
                        writer.write(this.objectMapper.writeValueAsString((Object)chartIndex));
                    }
                    if (reader == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (reader == null) throw throwable;
                    ((Reader)reader).close();
                    throw throwable;
                }
                ((Reader)reader).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.log.error("Error rewriting urls in index.yaml", (Throwable)ex);
        }
    }

    private void rewriteUrls(ChartEntry chartEntry) {
        List<String> urls = chartEntry.getUrls().stream().map(oldUrl -> this.rewriteUrl((String)oldUrl, chartEntry.getName(), chartEntry.getVersion())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        chartEntry.setUrls(urls);
    }

    private Optional<String> rewriteUrl(String oldUrl, String name, String version) {
        try {
            URI uri = new URIBuilder(oldUrl).build();
            String fileExtension = FilenameUtils.getExtension((String)uri.getPath());
            return Optional.of(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name, version, fileExtension}) ? String.valueOf(name) + "-" + version + "." + fileExtension : uri.getPath());
        }
        catch (URISyntaxException ex) {
            this.log.error("Invalid URI in index.yaml", (Throwable)ex);
            return Optional.empty();
        }
    }

    public Optional<String> getFirstUrl(Content indexYaml, String filename) {
        Preconditions.checkNotNull((Object)filename);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = indexYaml.openInputStream();){
                ChartIndex chartIndex = (ChartIndex)this.objectMapper.readValue(inputStream, ChartIndex.class);
                return chartIndex.getEntries().values().stream().flatMap(Collection::stream).filter(chart -> filename.startsWith(String.valueOf(chart.getName()) + "-")).filter(chart -> this.getChartVersion(filename, chart.getName()).equals(chart.getVersion())).flatMap(chart -> chart.getUrls().stream()).findFirst();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.error("Error reading index.yaml");
            throw new UncheckedIOException(e);
        }
    }

    private String getChartVersion(String filename, String chartName) {
        return FilenameUtils.removeExtension((String)filename).replace(String.valueOf(chartName) + "-", "");
    }
}

