/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal.metadata;

import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.metadata.ChartEntry;
import com.sonatype.repository.helm.internal.util.HelmAttributeParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;

@Named
@Singleton
public class ChartEntryHelper {
    private final HelmAttributeParser helmAttributeParser;

    @Inject
    public ChartEntryHelper(HelmAttributeParser helmAttributeParser) {
        this.helmAttributeParser = Objects.requireNonNull(helmAttributeParser);
    }

    public ChartEntry getChartEntryBasedOnBlob(FluentAsset fluentAsset) throws IOException {
        HelmAttributes helmAttributes = this.helmAttributeParser.getAttributes(AssetKind.HELM_PACKAGE, () -> fluentAsset.download().openInputStream());
        return this.convertToChartEntry((Asset)fluentAsset, helmAttributes);
    }

    public ChartEntry convertToChartEntry(Asset asset, HelmAttributes helmAttributes) {
        ChartEntry chartEntry = this.getChartEntry(helmAttributes);
        AssetBlob assetBlob = (AssetBlob)asset.blob().orElseThrow(() -> new NullPointerException(String.format("Unable convert to chart entry. No asset blob %s", asset.path())));
        chartEntry.setDigest((String)assetBlob.checksums().get(HashAlgorithm.SHA256.name()));
        chartEntry.setCreated(new DateTime((Object)assetBlob.blobCreated().toString()));
        return chartEntry;
    }

    private ChartEntry getChartEntry(HelmAttributes helmAttributes) {
        ChartEntry chartEntry = new ChartEntry();
        chartEntry.setName(helmAttributes.getName());
        chartEntry.setVersion(helmAttributes.getVersion());
        chartEntry.setDescription(helmAttributes.getDescription());
        chartEntry.setIcon(helmAttributes.getIcon());
        chartEntry.setMaintainers(helmAttributes.getMaintainers());
        chartEntry.setAppVersion(helmAttributes.getAppVersion());
        this.createListOfRelativeUrls(chartEntry, helmAttributes.getName(), helmAttributes.getVersion());
        chartEntry.setSources(helmAttributes.getSources());
        return chartEntry;
    }

    private void createListOfRelativeUrls(ChartEntry chartEntry, String name, String version) {
        ArrayList<String> urls = new ArrayList<String>();
        String url = String.format("%s-%s.tgz", name, version);
        urls.add(url);
        chartEntry.setUrls(urls);
    }
}

