/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.httpbridge.HttpResponseSender;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;

@Named(value="helm")
@Singleton
public class HelmHttpResponseSender
extends ComponentSupport
implements HttpResponseSender {
    private final HttpResponseSender defaultHttpResponseSender;

    @Inject
    public HelmHttpResponseSender(HttpResponseSender defaultHttpResponseSender) {
        this.defaultHttpResponseSender = (HttpResponseSender)Preconditions.checkNotNull((Object)defaultHttpResponseSender);
    }

    public void send(@Nullable Request request, Response response, HttpServletResponse httpResponse) throws ServletException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Payload payload = response.getPayload();){
            if (payload != null && "text/x-yaml".equals(payload.getContentType())) {
                httpResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.defaultHttpResponseSender.send(request, response, httpResponse);
    }
}

