/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.tasks;

import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.datastore.internal.createindex.HelmHostedIndexFacet;
import com.sonatype.repository.helm.datastore.internal.data.HelmKeyValueFacet;
import com.sonatype.repository.helm.internal.metadata.ChartEntry;
import com.sonatype.repository.helm.internal.metadata.ChartEntryHelper;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
public class RebuildHelmMetadataTask
extends RepositoryTaskSupport
implements Cancelable {
    @Inject
    private ChartEntryHelper chartEntryHelper;

    protected void execute(Repository repository) {
        this.log.debug("Populating data in repository {} started ", (Object)repository.getName());
        boolean isFullRebuild = this.getConfiguration().getBoolean("rebuildHelmMetadataFullRebuild", false);
        if (isFullRebuild) {
            this.executeFullRebuild(repository);
        } else {
            this.executeRebuild(repository);
        }
    }

    private void addChart(Repository repository, FluentAsset asset) {
        try {
            ChartEntry chartEntry = this.chartEntryHelper.getChartEntryBasedOnBlob(asset);
            ((HelmKeyValueFacet)repository.facet(HelmKeyValueFacet.class)).addChart((Asset)asset, chartEntry);
        }
        catch (IOException e) {
            this.log.warn("Error getting char entry for asset {} repository {}", new Object[]{asset.path(), asset.repository().getName(), this.log.isDebugEnabled() ? e : null});
        }
    }

    private void executeRebuild(Repository repository) {
        HelmContentFacet helmContentFacet = (HelmContentFacet)repository.facet(HelmContentFacet.class);
        helmContentFacet.getHelmPackageAssets().forEach(chart -> {
            CancelableHelper.checkCancellation();
            this.addChart(repository, (FluentAsset)chart);
        });
        ((HelmHostedIndexFacet)repository.facet(HelmHostedIndexFacet.class)).removeIndex();
        try {
            ((HelmHostedIndexFacet)repository.facet(HelmHostedIndexFacet.class)).getIndex();
        }
        catch (IOException e) {
            this.log.error("Error index rebuilding", (Throwable)(this.log.isDebugEnabled() ? e : null));
        }
    }

    private void executeFullRebuild(Repository repository) {
        Iterable<FluentAsset> assets = ((HelmContentFacet)repository.facet(HelmContentFacet.class)).getHelmPackageAssets();
        ((HelmKeyValueFacet)repository.facet(HelmKeyValueFacet.class)).removeAll();
        for (FluentAsset asset : assets) {
            CancelableHelper.checkCancellation();
            this.addChart(repository, asset);
        }
        ((HelmHostedIndexFacet)repository.facet(HelmHostedIndexFacet.class)).removeIndex();
        try {
            ((HelmHostedIndexFacet)repository.facet(HelmHostedIndexFacet.class)).getIndex();
        }
        catch (IOException e) {
            this.log.error("Error index rebuilding", (Throwable)(this.log.isDebugEnabled() ? e : null));
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository.getFormat().getValue().equals("helm") && repository.getType().getValue().equals("hosted");
    }

    public String getMessage() {
        return "Rebuilding Helm metadata in " + this.getRepositoryField();
    }
}

