/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.recipe;

import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.datastore.internal.createindex.HelmHostedIndexFacet;
import com.sonatype.repository.helm.datastore.internal.recipe.HelmHostedFacet;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.util.HelmAttributeParser;
import com.sonatype.repository.helm.internal.util.HelmPathUtils;
import java.io.InputStream;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class HostedHandlers
extends ComponentSupport {
    private HelmPathUtils helmPathUtils;
    private HelmAttributeParser helmPackageParser;
    public final Handler get = context -> {
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        if (assetKind == AssetKind.HELM_INDEX) {
            Content content = ((HelmHostedIndexFacet)context.getRepository().facet(HelmHostedIndexFacet.class)).getIndex().download();
            return content != null ? HttpResponses.ok((Payload)content) : HttpResponses.notFound();
        }
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = this.helmPathUtils.contentFilePath(state, true);
        Content content = ((HelmHostedFacet)context.getRepository().facet(HelmHostedFacet.class)).get(path);
        return content != null ? HttpResponses.ok((Payload)content) : HttpResponses.notFound();
    };
    public final Handler upload = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = this.helmPathUtils.buildContentAssetPath(state);
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        ((HelmHostedFacet)context.getRepository().facet(HelmHostedFacet.class)).upload(path, context.getRequest().getPayload(), assetKind);
        return HttpResponses.ok();
    };
    public final Handler push = context -> {
        HelmHostedFacet hostedFacet = (HelmHostedFacet)context.getRepository().facet(HelmHostedFacet.class);
        HelmContentFacet helmContentFacet = (HelmContentFacet)context.getRepository().facet(HelmContentFacet.class);
        PartPayload payload = this.getPartPayload(context);
        String fileName = payload.getName() != null ? payload.getName() : "";
        AssetKind assetKind = AssetKind.getAssetKindByFileName(fileName);
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            Response response;
            InputStream inputStream;
            TempBlob tempBlob;
            block16: {
                block15: {
                    tempBlob = helmContentFacet.getTempBlob((Payload)payload);
                    inputStream = tempBlob.get();
                    HelmAttributes attributes = this.helmPackageParser.getAttributes(assetKind, inputStream);
                    String path = hostedFacet.getPath(attributes, assetKind);
                    hostedFacet.upload(path, tempBlob, attributes, (Payload)payload, assetKind);
                    response = HttpResponses.created();
                    if (inputStream == null) break block15;
                    inputStream.close();
                }
                if (tempBlob == null) break block16;
                tempBlob.close();
            }
            return response;
            {
                catch (Throwable throwable2) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (tempBlob != null) {
                            tempBlob.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    };
    public final Handler delete = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String path = this.helmPathUtils.buildContentAssetPath(state);
        boolean deleted = ((HelmHostedFacet)context.getRepository().facet(HelmHostedFacet.class)).delete(path);
        return deleted ? HttpResponses.ok() : HttpResponses.notFound();
    };

    @Inject
    public HostedHandlers(HelmPathUtils helmPathUtils, HelmAttributeParser helmPackageParser) {
        this.helmPathUtils = (HelmPathUtils)((Object)Preconditions.checkNotNull((Object)((Object)helmPathUtils)));
        this.helmPackageParser = (HelmAttributeParser)Preconditions.checkNotNull((Object)helmPackageParser);
    }

    private PartPayload getPartPayload(Context context) {
        if (!context.getRequest().isMultipart()) {
            throw new ValidationErrorsException("request should be multipart");
        }
        return StreamSupport.stream(Objects.requireNonNull(context.getRequest().getMultiparts()).spliterator(), false).filter(partPayload -> "chart".equals(partPayload.getFieldName())).findFirst().orElseThrow(() -> new ValidationErrorsException("chart field required"));
    }
}

