/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.datastore.internal.createindex.HelmHostedIndexFacet;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.metadata.IndexYamlAbsoluteUrlRewriter;
import com.sonatype.repository.helm.internal.util.HelmAttributeParser;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.WritePolicy;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="helm")
public class HelmContentFacetImpl
extends ContentFacetSupport
implements HelmContentFacet {
    private static final String INDEX_YAML_ASSET_PATH = "/index.yaml";
    private static final Iterable<HashAlgorithm> HASHING = ImmutableList.of((Object)HashAlgorithm.MD5, (Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256);
    private final HelmAttributeParser helmAttributeParser;
    private final IndexYamlAbsoluteUrlRewriter indexYamlRewriter;

    @Inject
    public HelmContentFacetImpl(@Named(value="helm") @Named(value="helm") FormatStoreManager formatStoreManager, HelmAttributeParser helmAttributeParser, IndexYamlAbsoluteUrlRewriter indexYamlRewriter) {
        super(formatStoreManager);
        this.helmAttributeParser = (HelmAttributeParser)Preconditions.checkNotNull((Object)helmAttributeParser);
        this.indexYamlRewriter = (IndexYamlAbsoluteUrlRewriter)((Object)Preconditions.checkNotNull((Object)((Object)indexYamlRewriter)));
    }

    protected WritePolicy writePolicy(Asset asset) {
        WritePolicy writePolicy = super.writePolicy(asset);
        if (writePolicy == WritePolicy.ALLOW_ONCE && !Objects.equals(AssetKind.HELM_PACKAGE.name(), asset.kind())) {
            writePolicy = WritePolicy.ALLOW;
        }
        return writePolicy;
    }

    @Override
    public Iterable<FluentAsset> browseAssets() {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentAssets)this.assets()).browse(arg_0, arg_1));
    }

    @Override
    public Iterable<FluentAsset> browseAssetsByKind(AssetKind assetKind) {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)this.assets().byKind(assetKind.name())).browse(arg_0, arg_1));
    }

    @Override
    public Optional<FluentAsset> getIndexAsset() {
        return this.assets().path(INDEX_YAML_ASSET_PATH).find();
    }

    @Override
    public FluentAsset putIndex(Payload payload) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob blob = this.blobs().ingest(payload, HASHING);){
            return this.assets().path(INDEX_YAML_ASSET_PATH).kind(AssetKind.HELM_INDEX.name()).blob(blob).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Optional<Content> getAsset(String path) {
        return this.assets().path(path).find().map(FluentAsset::download);
    }

    @Override
    public Content putIndex(String path, Content content, AssetKind assetKind) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.blobs().ingest((Payload)content, HASHING);){
            HelmAttributes helmAttributes = this.helmAttributeParser.getAttributes(assetKind, blob.get());
            this.assets().path(path).kind(assetKind.name()).blob(blob).save().markAsCached((Payload)content).withAttribute("helm", (Object)helmAttributes);
            return this.indexYamlRewriter.removeUrlsFromIndexYaml(blob, content.getAttributes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public TempBlob getTempBlob(Payload payload) {
        return this.blobs().ingest(payload, HASHING);
    }

    @Override
    public Content putComponent(String path, Payload content, AssetKind assetKind) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = this.blobs().ingest(content, HASHING);){
            HelmAttributes helmAttributes = this.helmAttributeParser.getAttributes(assetKind, (InputStreamSupplier)blob);
            FluentAsset fluentAsset = ((FluentAsset)this.assets().path(path).kind(assetKind.name()).component((Component)this.components().name(helmAttributes.getName()).version(helmAttributes.getVersion()).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(helmAttributes.getVersion(), this.repository().getFormat())).getOrCreate()).blob(blob).save().withAttribute("helm", (Object)helmAttributes)).markAsCached(content);
            this.triggerHostedIndexMechanism((Asset)fluentAsset, helmAttributes);
            return fluentAsset.download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putComponent(String path, TempBlob tempBlob, HelmAttributes helmAttributes, Content content, AssetKind assetKind) {
        FluentAsset fluentAsset = ((FluentAsset)this.assets().path(path).kind(assetKind.name()).component((Component)this.components().name(helmAttributes.getName()).version(helmAttributes.getVersion()).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(helmAttributes.getVersion(), this.repository().getFormat())).getOrCreate()).blob(tempBlob).save().withAttribute("helm", (Object)helmAttributes)).markAsCached((Payload)content);
        this.triggerHostedIndexMechanism((Asset)fluentAsset, helmAttributes);
        return fluentAsset.download();
    }

    @Override
    public boolean delete(String path) {
        return this.assets().path(path).find().map(FluentAsset::delete).orElse(false);
    }

    @Override
    public Iterable<FluentAsset> getHelmPackageAssets() {
        FluentQuery query = this.assets().byFilter("kind = #{filterParams.assetKindFilter}", Collections.singletonMap("assetKindFilter", AssetKind.HELM_PACKAGE.name()));
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentQuery)query).browse(arg_0, arg_1));
    }

    private void triggerHostedIndexMechanism(Asset asset, HelmAttributes helmAttributes) {
        Repository repository = this.getRepository();
        if (!(repository.getType() instanceof HostedType) || !AssetKind.HELM_PACKAGE.name().equals(asset.kind())) {
            return;
        }
        ((HelmHostedIndexFacet)this.facet(HelmHostedIndexFacet.class)).addChart(asset, helmAttributes);
    }
}

