/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.repository.helm.datastore.data.HelmKeyValueDAO;
import com.sonatype.repository.helm.datastore.data.HelmKeyValueStore;
import com.sonatype.repository.helm.internal.metadata.ChartEntry;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.kv.KeyValue;
import org.sonatype.nexus.repository.content.kv.KeyValueFacetSupport;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named(value="helm")
@Facet.Exposed
public class HelmKeyValueFacet
extends KeyValueFacetSupport<HelmKeyValueDAO, HelmKeyValueStore> {
    private static final String CATEGORY = "";
    private final int limit;
    private final ObjectMapper objectMapper;

    @Inject
    public HelmKeyValueFacet(@Named(value="${nexus.helm.paging.size:-100}") @Named(value="${nexus.helm.paging.size:-100}") int limit, ObjectMapper objectMapper) {
        super("helm", HelmKeyValueDAO.class);
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0);
        this.objectMapper = objectMapper;
        this.limit = limit;
    }

    public List<KeyValue> browseKeyValues(Iterable<Integer> componentIds) {
        return StreamSupport.stream(componentIds.spliterator(), false).map(this::buildChartKeyPrefix).map(prefix -> this.findByCategoryAndKeyLike(CATEGORY, (String)prefix)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void remove(Iterable<KeyValue> keyValues) {
        for (KeyValue keyValue : keyValues) {
            this.remove(keyValue.getCategory(), keyValue.getKey());
        }
    }

    public void remove(Asset asset) {
        Component component = this.getComponent(asset);
        String key = this.buildChartKey(component, asset);
        this.remove(CATEGORY, key);
    }

    public void addChart(Asset asset, ChartEntry chartEntry) {
        Component component = this.getComponent(asset);
        String chartKey = this.buildChartKey(component, asset);
        String json = this.serialize(chartEntry);
        this.set(CATEGORY, chartKey, json);
    }

    public Stream<ChartEntry> browseValues() {
        return Continuations.streamOf((limit, continuationToken) -> this.browseValues(CATEGORY, (int)limit, (String)continuationToken), (int)this.limit).map(it -> this.deserialize(it.getValue())).filter(__ -> CancelableHelper.checkCancellation());
    }

    private Component getComponent(Asset asset) {
        return (Component)asset.component().orElseThrow(() -> new NullPointerException(String.format("Unable to proceed KeyValueStore operation. No component for asset %s", asset.path())));
    }

    private String buildChartKey(Component component, Asset asset) {
        int componentId = InternalIds.internalComponentId((Component)component);
        int assetId = InternalIds.internalAssetId((Asset)asset);
        return "chart-" + componentId + '-' + assetId;
    }

    private String buildChartKeyPrefix(int componentId) {
        return "chart-" + componentId + "-%";
    }

    private String serialize(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private ChartEntry deserialize(String json) {
        try {
            return (ChartEntry)this.objectMapper.readValue(json, ChartEntry.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

