/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.helm.datastore.internal.createindex;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.datastore.internal.HelmContentFacet;
import com.sonatype.repository.helm.datastore.internal.data.HelmKeyValueFacet;
import com.sonatype.repository.helm.internal.AssetKind;
import com.sonatype.repository.helm.internal.metadata.ChartEntry;
import com.sonatype.repository.helm.internal.metadata.ChartEntryHelper;
import com.sonatype.repository.helm.internal.metadata.ChartIndex;
import com.sonatype.repository.helm.internal.util.YamlParser;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.kv.KeyValue;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Facet.Exposed
public class HelmHostedIndexFacet
extends FacetSupport {
    private static final String REBUILD_COOPERATION_KEY = "rebuild-helm-chart-index";
    private static final String INDEX_YAML_API_VERSION = "v1";
    private static final String INDEX_YAML_CONTENT_TYPE = "text/x-yaml";
    private final ChartEntryHelper chartEntryHelper;
    private final YamlParser yamlParser;
    private final Cooperation2Factory.Builder cooperationBuilder;
    private Cooperation2 cooperation;

    @Inject
    public HelmHostedIndexFacet(ChartEntryHelper chartEntryHelper, YamlParser yamlParser, Cooperation2Factory cooperationFactory, @Named(value="${nexus.helm.metadata.cooperation.enabled:-true}") @Named(value="${nexus.helm.metadata.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.helm.metadata.cooperation.majorTimeout:-0s}") @Named(value="${nexus.helm.metadata.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.helm.metadata.cooperation.minorTimeout:-30s}") @Named(value="${nexus.helm.metadata.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.helm.metadata.cooperation.threadsPerKey:-100}") @Named(value="${nexus.helm.metadata.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        this.chartEntryHelper = Objects.requireNonNull(chartEntryHelper);
        this.yamlParser = Objects.requireNonNull(yamlParser);
        this.cooperationBuilder = Objects.requireNonNull(cooperationFactory).configure().enabled(cooperationEnabled).majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.cooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":helm-chart-index");
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(ComponentPurgedEvent event) {
        if (!this.matchesRepository((ContentStoreEvent)event)) {
            return;
        }
        List<Integer> componentIds = Arrays.stream(event.getComponentIds()).boxed().collect(Collectors.toList());
        List<KeyValue> keyValues = ((HelmKeyValueFacet)this.facet(HelmKeyValueFacet.class)).browseKeyValues(componentIds);
        if (keyValues.isEmpty()) {
            return;
        }
        ((HelmKeyValueFacet)this.facet(HelmKeyValueFacet.class)).remove(keyValues);
        this.removeIndex();
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent event) {
        if (!this.matchesRepository((ContentStoreEvent)event) || !this.matchesHelmPackage((AssetEvent)event)) {
            return;
        }
        ((HelmKeyValueFacet)this.facet(HelmKeyValueFacet.class)).remove(event.getAsset());
        this.removeIndex();
    }

    public FluentAsset getIndex() throws IOException {
        Optional<FluentAsset> index = ((HelmContentFacet)this.facet(HelmContentFacet.class)).getIndexAsset();
        if (index.isPresent()) {
            return index.get();
        }
        return (FluentAsset)this.cooperation.on(this::doRebuildIndex).cooperate(REBUILD_COOPERATION_KEY, new String[0]);
    }

    public void addChart(Asset asset, HelmAttributes helmAttributes) {
        ChartEntry chartEntry = this.chartEntryHelper.convertToChartEntry(asset, helmAttributes);
        ((HelmKeyValueFacet)this.facet(HelmKeyValueFacet.class)).addChart(asset, chartEntry);
        this.removeIndex();
    }

    public void removeIndex() {
        ((HelmContentFacet)this.facet(HelmContentFacet.class)).getIndexAsset().ifPresent(it -> {
            Set set = ((ContentMaintenanceFacet)this.facet(ContentMaintenanceFacet.class)).deleteAsset((Asset)it);
        });
    }

    private FluentAsset doRebuildIndex() {
        ChartIndex chartIndex = this.doBuildIndex();
        String yamlContent = this.yamlParser.getYamlContent(chartIndex);
        StringPayload payload = new StringPayload(yamlContent, INDEX_YAML_CONTENT_TYPE);
        return ((HelmContentFacet)this.facet(HelmContentFacet.class)).putIndex((Payload)payload);
    }

    private ChartIndex doBuildIndex() {
        ChartIndex chartIndex = new ChartIndex();
        ((HelmKeyValueFacet)this.facet(HelmKeyValueFacet.class)).browseValues().forEach(chartIndex::addEntry);
        chartIndex.setApiVersion(INDEX_YAML_API_VERSION);
        chartIndex.setGenerated(new DateTime());
        return chartIndex;
    }

    private boolean matchesRepository(ContentStoreEvent event) {
        String repoName = event.getRepository().map(Repository::getName).orElse(null);
        return this.getRepository().getName().equals(repoName);
    }

    private boolean matchesHelmPackage(AssetEvent event) {
        String kind = event.getAsset().kind();
        return AssetKind.HELM_PACKAGE.name().equals(kind);
    }
}

