/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.helm.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.blobstore.restore.helm.internal.orient.HelmRestoreBlobData;
import com.sonatype.repository.helm.HelmAttributes;
import com.sonatype.repository.helm.orient.HelmRestoreFacet;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.StringUtils;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;

@FeatureFlag(name="nexus.orient.enabled")
@Priority(value=0x7FFFFFFF)
@Named(value="helm")
@Singleton
public class OrientHelmRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<HelmRestoreBlobData> {
    @Inject
    public OrientHelmRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, dryRunPrefix);
    }

    protected HelmRestoreBlobData createRestoreData(RestoreBlobData restoreBlobData) {
        Preconditions.checkState((!StringUtils.isEmpty((String)restoreBlobData.getBlobName()) ? 1 : 0) != 0, (Object)"Blob name cannot be empty");
        return new HelmRestoreBlobData(restoreBlobData);
    }

    protected boolean canAttemptRestore(@Nonnull HelmRestoreBlobData helmRestoreBlobData) {
        Repository repository = this.getRepository(helmRestoreBlobData);
        Optional helmRestoreFacetFacet = repository.optionalFacet(HelmRestoreFacet.class);
        if (!helmRestoreFacetFacet.isPresent()) {
            this.log.warn("Skipping as Helm Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull HelmRestoreBlobData helmRestoreBlobData) {
        return helmRestoreBlobData.getBlobData().getBlobName();
    }

    protected boolean assetExists(@Nonnull HelmRestoreBlobData helmRestoreBlobData) {
        HelmRestoreFacet facet = this.getRestoreFacet(helmRestoreBlobData);
        return facet.assetExists(this.getAssetPath(helmRestoreBlobData));
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull HelmRestoreBlobData helmRestoreBlobData) throws IOException {
        HelmRestoreFacet facet = this.getRestoreFacet(helmRestoreBlobData);
        String path = this.getAssetPath(helmRestoreBlobData);
        facet.restore(assetBlob, path);
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256);
    }

    protected boolean componentRequired(HelmRestoreBlobData data) {
        HelmRestoreFacet facet = this.getRestoreFacet(data);
        String path = data.getBlobData().getBlobName();
        return facet.componentRequired(path);
    }

    protected Query getComponentQuery(HelmRestoreBlobData data) throws IOException {
        HelmRestoreFacet facet = this.getRestoreFacet(data);
        RestoreBlobData blobData = data.getBlobData();
        HelmAttributes attributes = facet.extractComponentAttributesFromArchive(blobData.getBlobName(), blobData.getBlob().getInputStream());
        return facet.getComponentQuery(attributes);
    }

    protected Repository getRepository(@Nonnull HelmRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    private HelmRestoreFacet getRestoreFacet(@Nonnull HelmRestoreBlobData helmRestoreBlobData) {
        Repository repository = this.getRepository(helmRestoreBlobData);
        return (HelmRestoreFacet)repository.facet(HelmRestoreFacet.class);
    }
}

