/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.prostarter.plugin.analytics.status;

import com.codahale.metrics.health.HealthCheck;
import com.sonatype.nexus.prostarter.plugin.analytics.ContentUsage;
import com.sonatype.nexus.prostarter.plugin.analytics.StarterAnalyticsConstants;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="Usage Limits")
@Singleton
public class BlockingHealthCheck
extends HealthCheck {
    private final Logger log = LoggerFactory.getLogger(BlockingHealthCheck.class);
    private final ContentUsage contentUsage;

    @Inject
    public BlockingHealthCheck(ContentUsage contentUsage) {
        this.contentUsage = contentUsage;
    }

    protected HealthCheck.Result check() {
        return this.contentUsage.shouldBlock() ? HealthCheck.Result.unhealthy((String)this.composeReason()) : HealthCheck.Result.healthy((String)"The instance is currently operating under the recommended limits");
    }

    private String composeReason() {
        Long dayRequestsCount = this.contentUsage.getMetrics().get("requests_per_last_24h");
        Long componentsCount = this.contentUsage.getMetrics().get("aggregated_components_count");
        if (dayRequestsCount != null && dayRequestsCount >= StarterAnalyticsConstants.REQUESTS_HARD_LIMIT) {
            return "The instance has reached or exceeded the recommended usage limits. Requests count: " + dayRequestsCount;
        }
        if (componentsCount != null && componentsCount >= StarterAnalyticsConstants.COMPONENTS_HARD_LIMIT) {
            return "The instance has reached or exceeded the recommended usage limits. Components count: " + componentsCount;
        }
        this.log.warn("Cannot compose reason for blocking requests check");
        return "Requests blocked by unknown reason";
    }
}

