/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.prostarter.plugin.analytics.handler;

import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.prostarter.plugin.analytics.BlockedRequestsMetric;
import com.sonatype.nexus.prostarter.plugin.analytics.ContentUsage;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.handlers.ContributedHandler;

@Named
@Singleton
@FeatureFlag(name="nexus.pro-starter.blocking.enabled")
public class BlockingContributedHandler
implements ContributedHandler {
    private static final String PROXY_REMOTE_FETCH_SKIP_MARKER = "proxy.remote-fetch.skip";
    private final ContentUsage contentUsage;
    private final BlockedRequestsMetric blockedRequestsMetric;

    @Inject
    public BlockingContributedHandler(ContentUsage contentUsage, BlockedRequestsMetric blockedRequestsMetric) {
        this.contentUsage = Objects.requireNonNull(contentUsage);
        this.blockedRequestsMetric = Objects.requireNonNull(blockedRequestsMetric);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        if (!this.contentUsage.shouldBlock()) {
            return context.proceed();
        }
        Type type = context.getRepository().getType();
        if (type instanceof ProxyType) {
            return this.proxyHandler(context);
        }
        if (type instanceof HostedType) {
            return this.hostedHandler(context);
        }
        return context.proceed();
    }

    private Response proxyHandler(Context context) throws Exception {
        Request request = context.getRequest();
        if (!this.proxyHandlerRequestMustBeVerified(request)) {
            return context.proceed();
        }
        context.getAttributes().set(PROXY_REMOTE_FETCH_SKIP_MARKER, (Object)true);
        Response response = context.proceed();
        if (response.getStatus().isSuccessful()) {
            return response;
        }
        this.blockedRequestsMetric.increment();
        return new Response.Builder().status(Status.failure((int)429)).build();
    }

    private Response hostedHandler(Context context) throws Exception {
        Request request = context.getRequest();
        if (!this.hostedHandlerRequestMustBeVerified(request)) {
            return context.proceed();
        }
        this.blockedRequestsMetric.increment();
        return new Response.Builder().status(Status.failure((int)429)).build();
    }

    @VisibleForTesting
    boolean proxyHandlerRequestMustBeVerified(Request request) {
        String action = request.getAction();
        return action.equals("GET");
    }

    @VisibleForTesting
    boolean hostedHandlerRequestMustBeVerified(Request request) {
        String action = request.getAction();
        return action.equals("POST") || action.equals("PUT");
    }
}

