/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.prostarter.plugin.analytics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.prostarter.plugin.analytics.BlockingStateMetric;
import com.sonatype.nexus.prostarter.plugin.analytics.StarterAnalyticsConstants;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.analytics.UsageMetrics;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.UsageMetricsAggregatedEvent;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class ContentUsage
extends LifecycleSupport
implements EventAware,
EventAware.Asynchronous {
    private final Provider<UsageMetrics> usageMetrics;
    private final AtomicBoolean shouldBlock = new AtomicBoolean(false);
    private final AtomicReference<Map<String, Long>> cachedMetrics = new AtomicReference(Collections.unmodifiableMap(new HashMap()));
    private final BlockingStateMetric blockingStateMetric;

    @Inject
    public ContentUsage(Provider<UsageMetrics> usageMetrics, BlockingStateMetric blockingStateMetric) {
        this.usageMetrics = Objects.requireNonNull(usageMetrics);
        this.blockingStateMetric = Objects.requireNonNull(blockingStateMetric);
    }

    public Map<String, Long> getMetrics() {
        return this.cachedMetrics.get();
    }

    public boolean shouldBlock() {
        return this.shouldBlock.get();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(UsageMetricsAggregatedEvent ignoredVar) {
        this.recalculate(true);
    }

    protected void doStart() {
        this.recalculate();
    }

    public void recalculate() {
        this.recalculate(false);
    }

    @VisibleForTesting
    public void recalculate(boolean blockingStateEventCounterEnable) {
        Map metrics = this.usageMetrics.get() == null ? new HashMap() : ((UsageMetrics)this.usageMetrics.get()).getMetrics();
        Long componentTotalCount = (Long)metrics.get("aggregated_components_count");
        Long contentRequestCount = (Long)metrics.get("requests_per_last_24h");
        boolean shouldBlockState = componentTotalCount != null && componentTotalCount >= StarterAnalyticsConstants.COMPONENTS_HARD_LIMIT || contentRequestCount != null && contentRequestCount >= StarterAnalyticsConstants.REQUESTS_HARD_LIMIT;
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("aggregated_components_count", componentTotalCount);
        map.put("requests_per_last_24h", contentRequestCount);
        this.shouldBlock.set(shouldBlockState);
        this.cachedMetrics.set(Collections.unmodifiableMap(map));
        if (blockingStateEventCounterEnable && shouldBlockState) {
            this.blockingStateMetric.increment();
        }
    }
}

